//
// bedev.C - BE memory extension for editing devices
//
// This is a rather simple implementation that simply seeks
// around an open device special file, and gets and puts bytes.
//

/*...sincludes:0:*/
#ifdef NO_CINCLUDES
  #include <stdio.h>
  #include <ctype.h>
  #include <string.h>
  #include <stddef.h>
  #include <stdlib.h>
  #include <stdarg.h>
#else
  #include <cstdio>
  #include <cctype>
  #include <cstring>
  #include <cstddef>
  #include <cstdlib>
  #include <cstdarg>
#endif

#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#ifndef O_BINARY
  #define O_BINARY 0
#endif

#include "bememext.h"
/*...e*/
/*...sPOSIX\47\ISO:0:*/
#ifdef WIN32
  #define fd_open  _open
  #define fd_close _close
  #define fd_read  _read
  #define fd_write _write
  #define fd_lseek _lseek
#else
  #define fd_open  open
  #define fd_close close
  #define fd_read  read
  #define fd_write write
  #define fd_lseek lseek
#endif
/*...e*/

/*...sclass BeMem:0:*/
class BeMem
	{
	int fd;
	Boolean read_only;
public:
	BeMem(int fd, Boolean read_only)
		: fd(fd), read_only(read_only) {}
	~BeMem() { fd_close(fd); }
	Boolean read(unsigned addr, unsigned char & b)
		{
		if ( fd_lseek(fd, addr, SEEK_SET) == -1 )
			return FALSE;
		return ::fd_read(fd, &b, 1) == 1;
		}
	Boolean write(unsigned addr, unsigned char b)
		{
		if ( read_only )
			return FALSE;
		if ( fd_lseek(fd, addr, SEEK_SET) == -1 )
			return FALSE;
		return ::fd_write(fd, &b, 1) == 1;
		}
	};
/*...e*/

/*...sbemem_read:0:*/
BEMEMEXPORT Boolean BEMEMENTRY bemem_read(void * ptr, unsigned addr, unsigned char & b)
	{
	BeMem *bemem = (BeMem *) ptr;
	return bemem->read(addr, b);
	}
/*...e*/
/*...sbemem_write:0:*/
BEMEMEXPORT Boolean BEMEMENTRY bemem_write(void * ptr, unsigned addr, unsigned char b)
	{
	BeMem *bemem = (BeMem *) ptr;
	return bemem->write(addr, b);
	}
/*...e*/
/*...sbemem_create:0:*/
BEMEMEXPORT void * BEMEMENTRY bemem_create(const char *args, unsigned addr, const char *(&err))
	{
	int fd;
	BeMem *bemem;
	addr=addr; // Suppress warning
	if ( !memcmp(args, "RO:", 3) )
		{
		if ( (fd = fd_open(args+3, O_RDONLY|O_BINARY)) == -1 )
			{ err = "can't open device in read only mode"; return 0; }
		bemem = new BeMem(fd, TRUE);
		}
	else
		{
		if ( (fd = fd_open(args, O_RDWR|O_BINARY)) == -1 )
			{ err = "can't open device in read/write mode"; return 0; }
		bemem = new BeMem(fd, FALSE);
		}
	if ( bemem == 0 )
		{ close(fd); err = "out of memory"; return 0; }
	return (void *) bemem;
	}
/*...e*/
/*...sbemem_delete:0:*/
BEMEMEXPORT void BEMEMENTRY bemem_delete(void * ptr)
	{
	BeMem *bemem = (BeMem *) ptr;
	delete bemem;
	}
/*...e*/

/*...sOS specifics:0:*/
#ifdef AIX

extern "C" {

BEMEM_EXPORT * __start(void)
	{
	static BEMEM_EXPORT exports[] =
		{
		(BEMEM_EP) bemem_read   , "bemem_read"   ,
		(BEMEM_EP) bemem_write  , "bemem_write"  ,
		(BEMEM_EP) bemem_create , "bemem_create" ,
		(BEMEM_EP) bemem_delete , "bemem_delete" ,
		(BEMEM_EP) 0            , 0
		};
	return exports;
	}

}

#endif
/*...e*/
