//
// bememu.C - BE memory extension for looking inside MEMU
//

/*...sincludes:0:*/
#ifdef NO_CINCLUDES
  #include <stdio.h>
  #include <ctype.h>
  #include <string.h>
  #include <stddef.h>
  #include <stdlib.h>
  #include <stdarg.h>
#else
  #include <cstdio>
  #include <cctype>
  #include <cstring>
  #include <cstddef>
  #include <cstdlib>
  #include <cstdarg>
#endif

#if defined(UNIX)
  #include <unistd.h>
  #include <fcntl.h>
#elif defined(WIN32)
  #include <windows.h>
#endif

#include "bememext.h"
/*...e*/

/*...sclass BeMem:0:*/
#define	IOBYTE_VRAM ((unsigned char) 0xff)

class BeMem
	{
#if defined(UNIX)
	int fd_out, fd_in;
#elif defined(WIN32)
	HANDLE hfPipe;
#endif
	unsigned char iobyte;
	unsigned char iobyte_cache;
	unsigned addr_cache;
	unsigned char cache[0x100];
/*...ssend:8:*/
void send(const unsigned char *buf, unsigned len)
	{
#if defined(UNIX)
	::write(fd_out, buf, len);
#elif defined(WIN32)
	DWORD cb;
	WriteFile(hfPipe, buf, len, &cb, NULL);
#endif
	}
/*...e*/
/*...srecv:8:*/
void recv(unsigned char *buf, unsigned len)
	{
#if defined(UNIX)
	do
		{
		int n = ::read(fd_in, buf, len);
		if ( n == -1 )
			return;
		buf += n;
		len -= n;
		}
	while ( len > 0 );
#elif defined(WIN32)
	DWORD cb;
	ReadFile(hfPipe, buf, len, &cb, NULL);
#endif
	}
/*...e*/
/*...sread_mem_block:8:*/
void read_mem_block(unsigned addr, unsigned char iobyte)
	{
	unsigned char buf[6];
	buf[0] = 0x00;
	buf[1] = iobyte;
	buf[2] = (unsigned char)  addr    ;
	buf[3] = (unsigned char) (addr>>8);
	buf[4] = 0x00;
	buf[5] = 0x01;
	send(buf, 6);
	recv(cache, 0x100);
	}
/*...e*/
/*...swrite_mem_byte:8:*/
void write_mem_byte(unsigned addr, unsigned char iobyte, unsigned char b)
	{
	unsigned char buf[7];
	buf[0] = 0x01;
	buf[1] = iobyte;
	buf[2] = (unsigned char)  addr    ;
	buf[3] = (unsigned char) (addr>>8);
	buf[4] = 0x01;
	buf[5] = 0x00;
	buf[6] = b;
	send(buf, 7);
	recv(buf, 1);
	}
/*...e*/
/*...sread_vram_block:8:*/
void read_vram_block(unsigned addr)
	{
	unsigned char buf[5];
	buf[0] = 0x02;
	buf[1] = (unsigned char)  addr    ;
	buf[2] = (unsigned char) (addr>>8);
	buf[3] = 0x00;
	buf[4] = 0x01;
	send(buf, 5);
	recv(cache, 0x100);
	}
/*...e*/
/*...swrite_vram_byte:8:*/
void write_vram_byte(unsigned addr, unsigned char b)
	{
	unsigned char buf[6];
	buf[0] = 0x03;
	buf[1] = (unsigned char)  addr    ;
	buf[2] = (unsigned char) (addr>>8);
	buf[3] = 0x01;
	buf[4] = 0x00;
	buf[5] = b;
	send(buf, 6);
	recv(buf, 1);
	}
/*...e*/
/*...sset_option:8:*/
Boolean set_option(const char *option, const char *(&err))
	{
	if ( !strncmp(option, "iobyte=", 7) )
		{
		int i = 0x00;
		sscanf(option+7, "%i", &i);
		iobyte = (unsigned char) i;
		return TRUE;
		}
	else if ( !strcmp(option, "vram") )
		{
		iobyte = IOBYTE_VRAM;
		return TRUE;
		}
	else
		{ err = "unknown option"; return FALSE; }
	}
/*...e*/
public:
/*...sBeMem:8:*/
BeMem(
#if defined(UNIX)
	int fd_out, int fd_in,
#elif defined(WIN32)
	HANDLE hfPipe,
#endif
	unsigned char iobyte
	)
	:
#if defined(UNIX)
	fd_out(fd_out), fd_in(fd_in),
#elif defined(WIN32)
	hfPipe(hfPipe),
#endif
	iobyte(iobyte),
	addr_cache(0xffff)
	{
	}
/*...e*/
/*...s\126\BeMem:8:*/
~BeMem()
	{
#if defined(UNIX)
	::close(fd_in);
	::close(fd_out);
#elif defined(WIN32)
	CloseHandle(hfPipe);
#endif
	}
/*...e*/
/*...srefresh:8:*/
void refresh() { addr_cache = 0xffff; }
/*...e*/
/*...sread:8:*/
Boolean read(unsigned addr, unsigned char & b)
	{
	if ( (addr&0xff00) != addr_cache || iobyte != iobyte_cache )
		{
		addr_cache = (addr&0xff00);
		iobyte_cache = iobyte;
		if ( iobyte == IOBYTE_VRAM )
			read_vram_block(addr_cache);
		else
			read_mem_block(addr_cache, iobyte_cache);
		}
	b = cache[addr&0x00ff];
	return TRUE;
	}
/*...e*/
/*...swrite:8:*/
Boolean write(unsigned addr, unsigned char b)
	{
	if ( iobyte == IOBYTE_VRAM )
		write_vram_byte(addr, b);
	else
		write_mem_byte(addr, iobyte, b);
	addr_cache = 0xffff;
	return TRUE;
	}
/*...e*/
/*...sset_options:8:*/
Boolean set_options(const char *options, const char *(&err))
	{
	char buf[200+1];
	strcpy(buf, options);
	for ( const char *p = strtok(buf, ", ");
	      p != 0;
	      p = strtok(0, ", ") )
		if ( !set_option(p, err) )
			return FALSE;
	return TRUE;
	}
/*...e*/
	};
/*...e*/

/*...sbemem_refresh:0:*/
BEMEMEXPORT void BEMEMENTRY bemem_refresh(void * ptr)
	{
	BeMem *bemem = (BeMem *) ptr;
	bemem->refresh();
	}
/*...e*/
/*...sbemem_read:0:*/
BEMEMEXPORT Boolean BEMEMENTRY bemem_read(void * ptr, unsigned addr, unsigned char & b)
	{
	BeMem *bemem = (BeMem *) ptr;
	return bemem->read(addr, b);
	}
/*...e*/
/*...sbemem_write:0:*/
BEMEMEXPORT Boolean BEMEMENTRY bemem_write(void * ptr, unsigned addr, unsigned char b)
	{
	BeMem *bemem = (BeMem *) ptr;
	return bemem->write(addr, b);
	}
/*...e*/
/*...sbemem_create:0:*/
BEMEMEXPORT void * BEMEMENTRY bemem_create(const char *args, unsigned addr, const char *(&err))
	{
	BeMem *bemem;
	int iobyte = 0x00;
	char token[100+1];
	sscanf(args, "%[^,],%i", token, &iobyte);
#if defined(UNIX)
	char fn_out[500+1]; // out to BEMEMU
	char fn_in[500+1];  // in from BEMEMU
	int fd_out;
	int fd_in;
	sprintf(fn_in, "/tmp/bememu-stat-%s", token);
	if ( (fd_in = ::open(fn_in, O_RDONLY)) == -1 )
		{ err = "can't open FIFO for reading"; return 0; }
	sprintf(fn_out, "/tmp/bememu-cmd-%s", token);
	if ( (fd_out = ::creat(fn_out, 0777)) == -1 )
		{ ::close(fd_in); err = "can't open FIFO for writing"; return 0; }
	bemem = new BeMem(fd_out, fd_in, (unsigned char) iobyte);
#elif defined(WIN32)
	char pipe[100+1];
	sprintf(pipe, "\\\\.\\pipe\\bememu-%s", token);
	HANDLE hfPipe;
	if ( (hfPipe = CreateFile(
		pipe,
		GENERIC_READ | GENERIC_WRITE,
		0,
		NULL,
		OPEN_EXISTING,
		0,
		NULL)) == INVALID_HANDLE_VALUE )
		{ err = "can't open named pipe"; return 0; }

	bemem = new BeMem(hfPipe, (unsigned char) iobyte);
#endif
	return (void *) bemem;
	}
/*...e*/
/*...sbemem_delete:0:*/
BEMEMEXPORT void BEMEMENTRY bemem_delete(void * ptr)
	{
	BeMem *bemem = (BeMem *) ptr;
	delete bemem;
	}
/*...e*/
/*...sbemem_options:0:*/
BEMEMEXPORT Boolean BEMEMENTRY bemem_options(void * ptr, const char *options, const char *(&err))
	{
	BeMem *bemem = (BeMem *) ptr;
	return bemem->set_options(options, err);
	}
/*...e*/
