#!/bin/ksh
#
# dis2m80.sh - Convert disassembly output to something M80 friendly
#

tr 'a-z' 'A-Z' |\
sed \
	-e 's/^\([^ ][^ ]*\) *+0X0000 : @........ /\1:	/g' \
	-e 's/^\([^ ][^ ]*\) *+0X.... : @........ /	/g' \
	-e 's/\<0X\([0-9A-F][0-9A-F][0-9A-F][0-9A-F]\)\>/0\1H/g' \
	-e 's/\<0X\([0-9A-F][0-9A-F]\)\>/0\1H/g' \
	-e 's/CALL    0[0-9A-F][0-9A-F][0-9A-F][0-9A-F]H{\([^}]*\)}/CALL	\1/g' \
	-e 's/CALL    \([ZC]\),0[0-9A-F][0-9A-F][0-9A-F][0-9A-F]H{\([^}]*\)}/CALL	\1,\2/g' \
	-e 's/CALL    N\([ZC]\)NZ,0[0-9A-F][0-9A-F][0-9A-F][0-9A-F]H{\([^}]*\)}/CALL	\1,\2/g' \
	-e 's/JP      0[0-9A-F][0-9A-F][0-9A-F][0-9A-F]H{\([^}]*\)}/JP	\1/g' \
	-e 's/JP      \(ZC\),0[0-9A-F][0-9A-F][0-9A-F][0-9A-F]H{\([^}]*\)}/JP	\1\2/g' \
	-e 's/JP      N\(ZC\),0[0-9A-F][0-9A-F][0-9A-F][0-9A-F]H{\([^}]*\)}/JP	\1/g' \
	-e 's/JR      0[0-9A-F][0-9A-F][0-9A-F][0-9A-F]H{\([^}]*\)}/JR	\1/g' \
	-e 's/JR      \(ZC\),0[0-9A-F][0-9A-F][0-9A-F][0-9A-F]H{\([^}]*\)}/JR	\1\2/g' \
	-e 's/JR      N\(ZC\),0[0-9A-F][0-9A-F][0-9A-F][0-9A-F]H{\([^}]*\)}/JR	\1/g' \
	-e 's/{__[^}]*}//g' \
	-e 's/   */	/g'

