.Z80
ASEG

	ORG	100H

PAGE	EQU	0FAD2H
LDSIZE	EQU	000C0H

LOADS::

.PHASE 02000H
; Header
	IFT	ASTART
	DB	8,7,6,5,4,3,2,1
	ELSE
	DB	0,0,0,0,0,0,0,0
	ENDIF
	DW	ROMID
	DB	0,0
; ROM x entrypoint at 0200CH
	JP	MAIN
	DB	0
; initialisation entrypoint at 02010H
	JP	MAIN

; Display ROM ID
ROMID:	DB	'CL10'
	RST	010H
	DB	084H
	DB	'CL10'
	RET

; Main
MAIN:	DI
	LD	HL,COPYS
	LD	DE,COPYD
	LD	BC,COPYDE-COPYD
	LDIR
	JP	COPYD
COPYS::
.DEPHASE

.PHASE 0FE00H
COPYD::
	XOR	A			; starting subpage
	EX	AF,AF'
	LD	DE,00100H
	LD	HL,02000H+LDSIZE
COPY2:	CALL	SETSRC
	LD	C,(HL)
	INC	HL
	LD	B,(HL)
	INC	HL
	CALL	COPY4
	CALL	SETSRC
	LD	A,(HL)
	INC	HL
	AND	A
	JR	Z,START
	LD	HL,02000H
	IFT	DUALROM
	LD	A,(PAGE)
	XOR	010H
	LD	(PAGE),A
	AND	010H
	JR	NZ,COPY2
	ENDIF
	EX	AF,AF'
	INC	A
	EX	AF,AF'
	JR	COPY2
; copy HL (page PAGE, subpage A') to DE (page 080H), BC bytes
; on return DE advanced by BC
COPY4:	LD	A,B
	AND	A
	JR	Z,COPY6
	PUSH	BC
	LD	BC,000FFH
	CALL	COPY6
	POP	BC
	DEC	B
	INC	BC
	JR	COPY4
; copy HL (page PAGE, subpage A') to DE (page 080H), BC bytes, BC <= 000FFH
; on return DE advanced by BC
COPY6:	LD	A,C
	AND	A
	RET	Z
	CALL	SETSRC
	PUSH	BC
	PUSH	DE
	LD	DE,0FF00H
	LDIR
	POP	DE
	POP	BC
	PUSH	HL
	LD	HL,0FF00H
	LD	A,080H
	OUT	(0),A
	LDIR
	POP	HL
	RET
;
SETSRC:	LD	A,(PAGE)
	OUT	(0),A
	EX	AF,AF'
	LD	(0),A
	EX	AF,AF'
	RET
; start
START:

CTC	EQU	8
	LD	B,2			;need to reset twice to be sure
	LD	A,3			;turn off channel control byte
LL2:	OUT	(CTC),A
	OUT	(CTC+1),A
	OUT	(CTC+2),A
	OUT	(CTC+3),A
	DJNZ	LL2

	LD	A,080H
	OUT	(0),A
	JP	00100H
COPYDE::
.DEPHASE

LOADP::
	DS	00100H+LDSIZE-$	; pad

LOADE::
