/*

com2rom.c - prepare ROM image

*/

/*...sincludes:0:*/
#include <stdio.h>
#include <string.h>
#include <stddef.h>
#include <stdlib.h>
#include <stdarg.h>
/*...e*/

static char progname[] = "com2rom";

/*...sfatal:0:*/
static void fatal(const char *fmt, ...)
	{
	va_list	vars;
	char s[256+1];
	va_start(vars, fmt);
	vsprintf(s, fmt, vars);
	va_end(vars);
	fprintf(stderr, "%s: %s\n", progname, s);
	exit(1);
	}
/*...e*/
/*...susage:0:*/
static void usage(void)
	{
	fprintf(stderr, "usage: %s loader.bin file.com file.rom\n", progname);
	fprintf(stderr, "flags: loader.bin  input ROM loader file\n");
	fprintf(stderr, "       file.com    input CP/M .com file\n");
	fprintf(stderr, "       file.rom    output ROM file\n");
	exit(1);
	}
/*...e*/
/*...smain:0:*/
#define	LOADER_SIZE	0x00c0
#define	COM_SIZE	(0xfc00-0x0100)
#define	CHUNK_SIZE	0x2000

int main(int argc, char *argv[])
	{
	FILE *fp;
	unsigned char loader[LOADER_SIZE];
	unsigned char com[COM_SIZE+1];
	size_t size, offset, chunk;

	if ( argc < 4 )
		usage();

	if ( (fp = fopen(argv[1], "rb")) == NULL )
		fatal("can't open loader file %s", argv[1]);
	size = fread(loader, 1, sizeof(loader), fp);
	fclose(fp);
	if ( size < LOADER_SIZE )
		fatal("loader file is too small");

	if ( (fp = fopen(argv[2], "rb")) == NULL )
		fatal("can't open .com file %s", argv[2]);
	size = fread(com, 1, sizeof(com), fp);
	fclose(fp);
	/* .com files are one or more CP/M sectors */
	if ( size == 0 || (size & 0x7f) != 0 )
		fatal(".com file is not one or more CP/M sectors in size");
	/* Note, at the time the ROM is invoked,
	   the stack will be somewhere between 0xfc00 and 0xfd00,
	   and the loader uses memory above 0xfe00.
	   Also note that .com files are loaded to 0x0100. */
	if ( size > COM_SIZE )
		fatal(".com file is too big");

	if ( (fp = fopen(argv[3], "wb")) == NULL )
		fatal("can't create ROM file %s", argv[3]);
	fwrite(loader, 1, LOADER_SIZE, fp);
	offset = 0;
	chunk = CHUNK_SIZE-LOADER_SIZE; /* first chunk is smaller */
	while ( size > 0 )
		{
		size_t thisgo = ( size < (chunk-3) ) ? size : (chunk-3);
		fputc(thisgo&0xff, fp);
		fputc(thisgo>>8  , fp);
		fwrite(com+offset, 1, thisgo, fp);
		offset += thisgo;
		size -= thisgo;
		chunk = CHUNK_SIZE;
		fputc(size>0, fp);
		}
	fclose(fp);

	return 0;
	}
/*...e*/
