
/*

BANNER.C  Draw big letters

(C) 1986  A.Key

usage: banner line1 line2 line3 ...
*/

#include "stdio.h"
#include "standard.h"
#include "ctype.h"

#define	CHARSIZ	8

/*
Sinclair Character Set
*/

int	charset [] [CHARSIZ] =	
	{
		{0,0,0,0,0,0,0,0},		/* */
		{0,16,16,16,16,0,16,0},		/*!*/
		{0,36,36,0,0,0,0,0},		/*"*/
		{0,36,126,36,36,126,36,0},	/*#*/
		{0,8,62,40,62,10,62,8},		/*$*/
		{0,98,100,8,16,38,70,0},	/*%*/
		{0,16,40,16,42,68,58,0},	/*&*/
		{0,8,16,0,0,0,0,0},		/*'*/
		{0,4,8,8,8,8,4,0},		/*(*/
		{0,32,16,16,16,16,32,0},	/*)*/
		{0,0,20,8,62,8,20,0},		/***/
		{0,0,8,8,62,8,8,0},		/*+*/
		{0,0,0,0,0,8,8,16},		/*,*/
		{0,0,0,0,62,0,0,0},		/*-*/
		{0,0,0,0,0,24,24,0},		/*.*/
		{0,0,2,4,8,16,32,0},		/*/*/
		{0,60,70,74,82,98,60,0},	/*0*/
		{0,24,40,8,8,8,62,0},		/*1*/
		{0,60,66,2,60,64,126,0},	/*2*/
		{0,60,66,12,2,66,60,0},		/*3*/
		{0,8,24,40,72,126,8,0},		/*4*/
		{0,126,64,124,2,66,60,0},	/*5*/
		{0,60,64,124,66,66,60,0},	/*6*/
		{0,126,2,4,8,16,16,0},		/*7*/
		{0,60,66,60,66,66,60,0},	/*8*/
		{0,60,66,66,62,2,60,0},		/*9*/
		{0,0,0,16,0,0,16,0},		/*:*/
		{0,0,16,0,0,16,16,32},		/*;*/
		{0,0,4,8,16,8,4,0},		/*<*/
		{0,0,0,62,0,62,0,0},		/*=*/
		{0,0,16,8,4,8,16,0},		/*>*/
		{0,60,66,4,8,0,8,0},		/*?*/
		{0,60,74,86,94,64,60,0},	/*@*/
		{0,60,66,66,126,66,66,0},	/*A*/
		{0,124,66,124,66,66,124,0},	/*B*/
		{0,60,66,64,64,66,60,0},	/*C*/
		{0,120,68,66,66,68,120,0},	/*D*/
		{0,126,64,124,64,64,126,0},	/*E*/
		{0,126,64,124,64,64,64,0},	/*F*/
		{0,60,66,64,78,66,60,0},	/*G*/
		{0,66,66,126,66,66,66,0},	/*H*/
		{0,62,8,8,8,8,62,0},		/*I*/
		{0,2,2,2,66,66,60,0},		/*J*/
		{0,68,72,112,72,68,66,0},	/*K*/
		{0,64,64,64,64,64,126,0},	/*L*/
		{0,66,102,90,66,66,66,0},	/*M*/
		{0,66,98,82,74,70,66,0},	/*N*/
		{0,60,66,66,66,66,60,0},	/*O*/
		{0,124,66,66,124,64,64,0},	/*P*/
		{0,60,66,66,82,74,60,0},	/*Q*/
		{0,124,66,66,124,68,66,0},	/*R*/
		{0,60,64,60,2,66,60,0},		/*S*/
		{0,126,16,16,16,16,16,0},	/*T*/
		{0,66,66,66,66,66,60,0},	/*U*/
		{0,66,66,66,66,36,24,0},	/*V*/
		{0,66,66,66,66,90,36,0},	/*W*/
		{0,66,36,24,24,36,66,0},	/*X*/
		{0,130,68,40,16,16,16,0},	/*Y*/
		{0,126,4,8,16,32,126,0},	/*Z*/
		{0,14,8,8,8,8,14,0},		/*[*/
		{0,0,64,32,16,8,4,0},		/*\*/
		{0,112,16,16,16,16,112,0},	/*]*/
		{0,16,56,84,16,16,16,0},	/*^*/
		{0,0,0,0,0,0,0,255},		/*_*/
		{0,28,34,120,32,32,126,0},	/*`*/
		{0,0,56,4,60,68,60,0},		/*a*/
		{0,32,32,60,34,34,60,0},	/*b*/
		{0,0,28,32,32,32,28,0},		/*c*/
		{0,4,4,60,68,68,60,0},		/*d*/
		{0,0,56,68,120,64,60,0},	/*e*/
		{0,12,16,24,16,16,16,0},	/*f*/
		{0,0,60,68,68,60,4,56},		/*g*/
		{0,64,64,120,68,68,68,0},	/*h*/
		{0,16,0,48,16,16,56,0},		/*i*/
		{0,4,0,4,4,4,36,24},		/*j*/
		{0,32,40,48,48,40,36,0},	/*k*/
		{0,16,16,16,16,16,12,0},	/*l*/
		{0,0,104,84,84,84,84,0},	/*m*/
		{0,0,120,68,68,68,68,0},	/*n*/
		{0,0,56,68,68,68,56,0},		/*o*/
		{0,0,120,68,68,120,64,64},	/*p*/
		{0,0,60,68,68,60,4,6},		/*q*/
		{0,0,28,32,32,32,32,0},		/*r*/
		{0,0,56,64,56,4,120,0},		/*s*/
		{0,16,56,16,16,16,12,0},	/*t*/
		{0,0,68,68,68,68,56,0},		/*u*/
		{0,0,68,68,40,40,16,0},		/*v*/
		{0,0,68,84,84,84,40,0},		/*w*/
		{0,0,68,40,16,40,68,0},		/*x*/
		{0,0,68,68,68,60,4,56},		/*y*/
		{0,0,124,8,16,32,124,0},	/*z*/
		{0,12,16,16,32,16,12,0},		/*{*/
		{0,8,8,8,8,8,8,0},		/*|*/
		{0,48,8,8,4,8,48,0},		/*}*/
		{0,0,0,0,0,0,0,0},		/*~ allows two word on line */
		{0,126,126,126,126,126,126,0}	/*DEL*/
	};

void	slice (c, row)
char	c;
int	row;
{
	int	mask;

	for (mask = 0x80; mask; mask /= 2)
		if (charset [c-' '] [row] & mask)
			putchar ('#');
		else
			putchar (' ');
}

void	display (s)
char	*s;
{
	int	i, j;
	char	*cp;

	for (i = 0; i < CHARSIZ; i++)
		{
		cp = s;
		while ( *cp )
			slice (*cp++, i);
		putchar ('\n');
		}
}

main (argc, argv)
int	argc;
char	*argv [];
{
	int	i;

	for (i = 1; i < argc; i++)
		display (argv [i]);
}
