/*

SGTTY.H  Interface to terminal control stuff

(C) 18/7/87  A.Key

Note: gtty(), stty() and ioctl() not supplied with 1.05G Aztec C

*/

#define	TIOCGETP 0
#define	TIOCSETP 1
#define	TIOCSETN 1

#define	gtty(fd,buf) ioctl(fd,TIOCGETP,buf)
#define	stty(fd,buf) ioctl(fd,TIOCSETP,buf)

#define	RAW	1			/* characters are presented as soon  */
					/* as they are read, no flow control */
#define	CBREAK	2			/* characters are presented as soon  */
					/* as they are read in               */
#define	ECHO	4			/* if set => characters are echoed   */
					/* as they are typed                 */

struct sgttyb
	{
	char	sg_erase;		/* ignored */
	char	sg_kill;		/* ignored */
	short	sg_flags;
	}

extern int ioctl ();			/* returns -1 if fails */
