#
# makedisk.sh - Make a floppy disk image
#
# usage: makedisk.sh file.mfloppy type systemsize {file}
#

fn=$1 ; shift
type=$1 ; shift
size=$1 ; shift

case $type in
	03)
		dd if=/dev/zero count=320 bs=1k > $fn 2> /dev/null
		;;
	07)
		dd if=/dev/zero count=640 bs=1k > $fn 2> /dev/null
		;;
esac

mkfs.cpm -f memotech-type07 -b boot${size}.dat $fn
cpmcp -f memotech-type${type} $fn $* 0:
