#!/bin/ksh
#
# syscopy.sh - Put a "system" on the first 2 tracks of a disk image
#
# Somewhat like the Memotech CP/M SYSCOPY.COM program.
#
# eg: $ ./syscopy.sh mydisk.mfloppy 59
#

d=`dirname $0`

usage()
	{
	print "usage: $0 file.mfloppy size"
	exit 1
	}

if [[ "$1" = "" ]] ; then
	usage
fi
f="$1"

if [[ ! -w "$f" ]] ; then
	print "$0: can't apply a system to $f"
	exit 2
fi

if [[ "$2" = "" ]] ; then
	sys=59
else
	sys=$2
fi

if [[ ! -r $d/boot${sys}.dat ]] ; then
	print "$0: $d/boot${sys}.dat missing"
	exit 3
fi

dd if=$d/boot${sys}.dat of=$f conv=notrunc 2> /dev/null
