;
;************************************
;* Sequential CP/M Disc IO routines *
;************************************
;
;(C) 11/3/87 A.Key
;
;Corrects bug with failing to start at first extent
;New block read and write and existence check
;
CFCB:	DW	0
CCOUNT:	DW	0
CRWFLG:	DW	0
CDMA:	DW	0
;
;>>DSEL ----- DISC CHANNEL SELECT
;
;HL-->channel x
;	where channel is of format DW FCB ! DB 0 ! DB 0 ! DS 128
;
DSEL:	CALL	DEHL
	LD	(CFCB),DE
	LD	(CCOUNT),HL
	INC	HL
	LD	(CRWFLG),HL
	INC	HL
	LD	(CDMA),HL
	RET
;
;>>DERASE ----- ERASE CURRENTLY SELECTED FILE
;
DERASE:	LD	C,DELFIL
	LD	DE,(CFCB)
	JP	BDOS
;
;>>DMAKE ----- DISC CHANNEL OPEN WITH NEW FILE CREATION
;
DMAKE:	CALL	DERASE
	LD	C,MAKFIL
	JR	DOPEN2
;
;>>DOPEN ----- DISC FILE STREAM OPEN
;
DOPEN:	LD	C,OPENF
DOPEN2:	LD	HL,(CFCB)
	LD	DE,12
	ADD	HL,DE
	LD	(HL),0		;access from first extent
	LD	DE,32-12
	ADD	HL,DE
	LD	(HL),0		;zero cr field of fcb (access from
				;the start of the extent)
	LD	DE,(CFCB)
	CALL	BDOS
	INC	A
	JP	Z,DERROR
	LD	HL,(CCOUNT)
	LD	(HL),0		;no bytes written/read
	RET
;
;>>DREAD ----- READ A FROM CURRENT STREAM
;
DREAD:	LD	HL,(CRWFLG)
	LD	(HL),0		;flag reading
	LD	HL,(CCOUNT)
	LD	A,(HL)
	AND	A
	JR	NZ,DREAD2
;get record
	LD	DE,(CDMA)
	LD	C,SETDMA
	CALL	BDOS
	LD	DE,(CFCB)
	LD	C,RSEQ
	CALL	BDOS
	AND	A
	JP	NZ,DERROR
;get byte from dma
DREAD2:	LD	HL,(CCOUNT)
	LD	C,(HL)
	INC	(HL)
	RES	7,(HL)
	LD	B,0
	LD	HL,(CDMA)
	ADD	HL,BC
	LD	A,(HL)
	RET
;
;>>DWRITE ----- WRITE A TO CURRENT STREAM
;
DWRITE:	LD	HL,(CRWFLG)
	LD	(HL),1		;flag writing
;put byte into dma
	LD	HL,(CCOUNT)
	LD	C,(HL)
	INC	(HL)
	RES	7,(HL)
	LD	B,0
	LD	HL,(CDMA)
	ADD	HL,BC
	LD	(HL),A
;write record?
	LD	HL,(CCOUNT)
	LD	A,(HL)
	AND	A
	RET	NZ
	LD	DE,(CDMA)
	LD	C,SETDMA
	CALL	BDOS
	LD	DE,(CFCB)
	LD	C,WSEQ
	JP	BDOS
;
;>>DCLOSE ----- CLOSE DISC STREAM
;
DCLOSE:	LD	HL,(CRWFLG)
	LD	A,(HL)
	AND	A
	JR	Z,DCLOS2
;buffer empty?
	LD	HL,(CCOUNT)
	LD	A,(HL)
	AND	A
	JR	Z,DCLOS2
;empty it
	LD	DE,(CDMA)
	LD	C,SETDMA
	CALL	BDOS
	LD	DE,(CFCB)
	LD	C,WSEQ
	CALL	BDOS
;
DCLOS2:	LD	DE,(CFCB)
	LD	C,CLOSEF
	JP	BDOS
;
;>>DBREAD ----- DISC BLOCK READ AT HL
;
;Return NZ if block cannot be read
;
DBREAD:	EX	DE,HL
	LD	C,SETDMA
	CALL	BDOS
	LD	HL,(CRWFLG)
	LD	(HL),0		;flag reading
	LD	DE,(CFCB)
	LD	C,RSEQ
	CALL	BDOS
	AND	A		;NZ => cannot read block
	RET
;
;>>DBWRIT ----- DISC BLOCK WRITE FROM HL
;
DBWRIT:	EX	DE,HL
	LD	C,SETDMA
	CALL	BDOS
	LD	HL,(CRWFLG)
	LD	(HL),1		;flag writing
	LD	DE,(CFCB)
	LD	C,WSEQ
	JP	BDOS
;
;>>DCHECK ----- CHECK FOR EXISTANCE OF FILE ON CURRENT CHANNEL
;
;Returns Z if does not exist
;
DCHECK:	LD	DE,(CFCB)
	LD	C,SFF
	CALL	BDOS
	INC	A
	RET
;
;DEHL ----- LD DE,(HL)
;
DEHL:	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	INC	HL
	RET
;
	IF	NOT OWNERR
;
;DERROR ----- DO "DISC ERROR" AND BOOT
;
DERROR:	LD	DE,DERROM
	LD	C,PRINTF
	CALL	BDOS
	RST	0
;
DERROM:	DB	CR,LF,'Disc Error. Warm booting$'
;
	ENDIF
