;
; EGAG.ASM  Fast Graphics for EGA
;
; (C) 9/9/88  A.Key
;
;...sincludes:0:
		INCLUDE	INTDOS.INC
		INCLUDE	INTVID.INC
;...e
;...sequates:0:
seg_ega		EQU	0A000H
ega_ctrl	EQU	003CEH
ega_data	EQU	003CFH
bit_mask_reg	EQU	008H
mode_reg	EQU	005H

EGAMODE		MACRO	mode
		MOV	DX,ega_ctrl
		MOV	AL,mode_reg
		OUT	DX,AL
		INC	DX
		MOV	AL,mode
		OUT	DX,AL
		ENDM

max_sprite	EQU	100

bytes_per_spr	EQU	128
;...e
;...sdata_seg:0:
data_seg	SEGMENT	'data'

		DB	8192 DUP (0)	; must be first, hold mask

t_plot		EQU	0
t_line		EQU	1
t_diag_vert	EQU	2
t_vert_diag	EQU	3
t_rect		EQU	4

jmp_tab		DW	OFFSET mask_plot
		DW	OFFSET mask_line
		DW	OFFSET mask_diag_vert
		DW	OFFSET mask_vert_diag
		DW	OFFSET mask_rect

item		STRUC

item_type	DB	?		; t_plot, t_line etc.
item_dx		DB	?
item_dy		DB	?
item_dz		DB	?		; distance coefficients
item_min_x	DW	?
item_max_x	DW	?
item_min_y	DW	?
item_max_y	DW	?
item_x1		DW	?
item_y1		DW	?
item_x2		DW	?
item_y2		DW	?

item		ENDS

max_items	EQU	250
item_ptr	DW	OFFSET item_table

item_table	EQU	$
REPT		max_items
		item	<>
ENDM
sccs_id		DB	'@(#)Fast EGA graphic routines  3/9/88', 0

font_fn		DB	'chars.ef',0
charset		DW	6 DUP (?)	; header
char_data	DB	8 * (176-32) DUP (?)

sprite_fn	DB	'sprites.es',0
sprtab		DW	3 DUP (?)	; header
spr_data	DB	max_sprite * bytes_per_spr DUP (?)

shifted_data	DB	3 * 4 * 16 + 3 * 4 * 16 DUP (?)

precalc		STRUC

precalc_d	DW	?		; distance factor
precalc_x	DW	?		; screen x
precalc_y	DW	?		; screen y
precalc_spos	DW	?		; destination screen address
precalc_sseg	DW	?		; destination screen segment
precalc_mask	DB	3 * 4 * 16 DUP (?)

precalc		ENDS

max_precalc	EQU	50
precalc_ptr	DW	OFFSET precalc_table

precalc_table	EQU	$
REPT		max_precalc
		precalc	<>
ENDM

refresh		STRUC

refresh_x	DW	?
refresh_y	DW	?
refresh_addr	DW	?

refresh		ENDS

max_refresh	EQU	2 * max_precalc
refresh_ptr	DW	OFFSET refresh_table

refresh_table	EQU	$
REPT		max_refresh
		refresh	<>
ENDM

prev_x		DW	?
prev_y		DW	?

data_seg	ENDS
;...e
;...sEGAG_TEXT:0:
EGAG_TEXT	SEGMENT PUBLIC 'code'

		ASSUME	CS:EGAG_TEXT, DS:data_seg

;...spublics:0:
		PUBLIC	g_init
		PUBLIC	g_deinit

		PUBLIC	g_s_print

		PUBLIC	g_s_plot
		PUBLIC	g_s_line
		PUBLIC	g_s_unline
		PUBLIC	g_s_diag_vert
		PUBLIC	g_s_vert_diag
		PUBLIC	g_s_rect
		PUBLIC	g_s_tri

		PUBLIC	g_s_update
		PUBLIC	g_s_clear
		PUBLIC	g_s_copy

		PUBLIC	g_l_plot
		PUBLIC	g_l_line
		PUBLIC	g_l_diag_vert
		PUBLIC	g_l_vert_diag
		PUBLIC	g_l_rect

		PUBLIC	g_clear_log

		PUBLIC	g_clear_spr

		PUBLIC	g_precalc
		PUBLIC	g_sprites
		PUBLIC	g_unsprite
		PUBLIC	g_refresh

		PUBLIC	g_sync
;...e
;...svars:0:
old_video_mode	DB	?
ega_base	DW	seg_ega		; segment of ega

last_filled	DW	?
x_lim		DW	?

step_always	DW	?		; this block of vars used by line_guts
step_sometimes	DW	?
plotter		DW	?
current_x	DW	?
current_y	DW	?
;...e

;...sBOOLEAN pascal g_init\40\\41\:0:
;
; BOOLEAN pascal g_init()
;
g_init		PROC	FAR

		PUSH	DS
		MOV	AX,SEG data_seg
		MOV	DS,AX

		MOV	DX,OFFSET font_fn
		MOV	AL,0
		DOSCALL	dos_open_fh
		JC	g_init_error
		PUSH	AX
		MOV	BX,AX
		MOV	CX,6*2 + (176-32)*8
		MOV	DX,OFFSET charset
		DOSCALL	dos_read_fh
		POP	BX
		DOSCALL	dos_close_fh

		MOV	DX,OFFSET sprite_fn
		MOV	AL,0
		DOSCALL	dos_open_fh
		JC	g_init_error
		PUSH	AX
		MOV	BX,AX
		MOV	CX,3*2 + max_sprite * bytes_per_spr
		MOV	DX,OFFSET sprtab
		DOSCALL	dos_read_fh
		POP	BX
		DOSCALL	dos_close_fh

		POP	DS

		VIDCALL	vid_get_mode
		MOV	CS:[old_video_mode],AL
		MOV	AL,0DH		; 320 x 200, 16 cols
		VIDCALL	vid_set_mode

		EGAMODE	2

		MOV	AX,1
		RET

g_init_error:	POP	DS
		XOR	AX,AX
		RET

g_init		ENDP
;...e
;...svoid pascal g_deinit\40\\41\:0:
;
; void pascal g_deinit()
;
g_deinit	PROC	FAR

		MOV	AL,CS:[old_video_mode]
		VIDCALL	vid_set_mode
		RET

g_deinit	ENDP
;...e

;...svoid pascal g_s_print\40\string\44\ x\44\ y\44\ col\41\:0:
;
; void pascal g_s_print(string, x, y, col)
;
; x and y are given in character positions, not pixels
;
string		= 12
x		= 10
y		= 8
col		= 6
;
g_s_print	PROC	FAR

		PUSH	BP
		MOV	BP,SP
		PUSH	ES

		MOV	CX,[BP+x]
		MOV	DX,[BP+y]
		MOV	BX,CS:[ega_base]
		CALL	calc_char_addr	; ES:DI -> screen
		MOV	BX,[BP+col]
		MOV	SI,[BP+string]

g_s_print_next:	LODSB
		AND	AL,AL
		JZ	SHORT g_s_print_done
		PUSH	DS
		MOV	CX,SEG data_seg
		MOV	DS,CX
		PUSH	SI
		XOR	AH,AH
		SUB	AL,' '
		SHL	AX,1
		SHL	AX,1
		SHL	AX,1
		MOV	SI,OFFSET char_data
		ADD	SI,AX

		MOV	DX,ega_ctrl
		MOV	AL,bit_mask_reg
		OUT	DX,AL
		INC	DX

		MOV	CX,8
g_s_print_loop:	LODSB
		OUT	DX,AL
		MOV	BL,ES:[DI]	; set latches
		MOV	ES:[DI],BH	; set colour
		ADD	DI,40
		LOOP	g_s_print_loop
		ADD	DI,-8*40+1
		POP	SI
		POP	DS
		JMP	g_s_print_next

g_s_print_done:	POP	ES
		POP	BP
		RET	8

g_s_print	ENDP
;...e

;...svoid pascal g_s_plot\40\x\44\ y\44\ col\41\:0:
;
; void pascal g_s_plot(x, y, col)
;
x		= 10
y		= 8
col		= 6
;
g_s_plot	PROC	FAR

		PUSH	BP
		MOV	BP,SP
		MOV	CX,[BP+x]
		MOV	DX,[BP+y]
		MOV	AX,[BP+col]
		PUSH	ES
		CALL	plot_guts
		POP	ES
		RET	6

g_s_plot	ENDP
;...e
;...svoid pascal g_s_line\40\x1\44\ y1\44\ x2\44\ y2\44\ col\41\:0:
;
; void pascal g_s_line(x1, y1, x2, y2, col)
;
x1		= 14
y1		= 12
x2		= 10
y2		= 8
col		= 6
;
g_s_line	PROC	FAR

		PUSH	BP
		MOV	BP,SP
		PUSH	ES
		MOV	AX,OFFSET plot
		CALL	line_guts
		POP	ES
		POP	BP
		RET	10

g_s_line	ENDP
;...e
;...svoid pascal g_s_unline\40\x1\44\ y1\44\ x2\44\ y2\44\ col\41\:0:
;
; void pascal g_s_unline(page_from, x1, y1, x2, y2, col)
;
page_from	= 16
x1		= 14
y1		= 12
x2		= 10
y2		= 8
col		= 6
;
g_s_unline	PROC	FAR

		PUSH	BP
		MOV	BP,SP
		PUSH	ES
		PUSH	DS
		MOV	AX,[BP+page_from]
		CALL	calc_page_seg
		MOV	DS,AX

		EGAMODE	1

		MOV	AX,OFFSET unplot
		CALL	line_guts

		EGAMODE	2

		POP	DS
		POP	ES
		POP	BP
		RET	12

g_s_unline	ENDP
;...e
;...svoid pascal g_s_diag_vert\40\x\44\ x1\44\ y1\44\ x2\44\ y2\44\ col\41\:0:
;
; void pascal g_s_diag_vert(x, x1, y1, x2, y2, col)
;
x		= 16
x1		= 14
y1		= 12
x2		= 10
y2		= 8
col		= 6
;
g_s_diag_vert	PROC	FAR

		PUSH	BP
		MOV	BP,SP
		PUSH	ES
		MOV	AX,[BP+x]
		MOV	CS:[x_lim],AX
		MOV	CS:[last_filled],-1
		MOV	AX,OFFSET plot_and_line
		CALL	line_guts
		POP	ES
		POP	BP
		RET	12

g_s_diag_vert	ENDP
;...e
;...svoid pascal g_s_vert_diag\40\x\44\ x1\44\ y1\44\ x2\44\ y2\44\ col\41\:0:
;
; void pascal g_s_vert_diag(x, x1, y1, x2, y2, col)
;
x		= 16
x1		= 14
y1		= 12
x2		= 10
y2		= 8
col		= 6
;
g_s_vert_diag	PROC	FAR

		PUSH	BP
		MOV	BP,SP
		PUSH	ES
		MOV	AX,[BP+x]
		MOV	CS:[x_lim],AX
		MOV	CS:[last_filled],-1
		MOV	AX,OFFSET line_and_plot
		CALL	line_guts
		POP	ES
		POP	BP
		RET	12

g_s_vert_diag	ENDP
;...e
;...svoid pascal g_s_rect\40\x1\44\ y1\44\ x2\44\ y2\44\ col\41\:0:
;
; void pascal g_s_rect(x1, y1, x2, y2, col)
;
x1		= 14
y1		= 12
x2		= 10
y2		= 8
col		= 6
;
g_s_rect	PROC	FAR

		PUSH	BP
		MOV	BP,SP
		PUSH	ES

		MOV	CX,[BP+x1]	; ensure x1 < x2
		MOV	AX,[BP+x2]
		CMP	CX,AX
		JC	g_s_rect_x_ok
		XCHG	CX,AX
		MOV	[BP+x1],CX
		MOV	[BP+x2],AX
g_s_rect_x_ok:
		MOV	DX,[BP+y1]	; ensure y1 < y2
		MOV	AX,[BP+y2]
		CMP	DX,AX
		JC	g_s_rect_y_ok
		XCHG	DX,AX
		MOV	[BP+y1],DX
		MOV	[BP+y2],AX
g_s_rect_y_ok:
		CALL	rect_guts
		POP	ES
		POP	BP
		RET	10

g_s_rect	ENDP
;...e
;...svoid pascal g_s_tri\40\x1\44\ y1\44\ x2\44\ y2\44\ x3\44\ y3\44\ col\41\:0:
		ASSUME	DS:EGAG_TEXT

line_table	DW	200 DUP (?, ?)
line_table_end	EQU	$

CLIP		MACRO	reg,rhs
		LOCAL	l2,l4

		CMP	reg,0
		JGE	l2
		XOR	reg,reg
		JMP	SHORT l4
l2:		CMP	reg,rhs
		JL	l4
		MOV	reg,rhs - 1
l4:
		ENDM
;
; void pascal g_s_tri(x1, y1, x2, y2, x3, y3, col)
;
x1		= 18
y1		= 16
x2		= 14
y2		= 12
x3		= 10
y3		= 8
col		= 6
;
t_x1		DW	?
t_y1		DW	?
t_x2		DW	?
t_y2		DW	?
;
g_s_tri		PROC	FAR

		PUSH	BP
		MOV	BP,SP
		PUSH	DS
		PUSH	ES
		MOV	AX,SEG EGAG_TEXT
		MOV	DS,AX
		MOV	ES,AX

		MOV	AX,[BP+y1]	; AX = lowest x value so far
		MOV	BX,AX		; BX = highest x value so far

		MOV	CX,[BP+y2]
		CMP	AX,CX
		JLE	gst_2
		MOV	AX,CX
gst_2:		CMP	BX,CX
		JGE	gst_4
		MOV	BX,CX
gst_4:
		MOV	CX,[BP+y3]
		CMP	AX,CX
		JLE	gst_6
		MOV	AX,CX
gst_6:		CMP	BX,CX
		JGE	gst_8
		MOV	BX,CX
gst_8:
					; now AX = lowest x value (signed)
					; now BX = highest y value (signed)

		CLIP	AX,200
		CLIP	BX,200
;
; Now blank relevant section of table
;

		MOV	DI,AX
		PUSH	AX		; usefull later
		SHL	DI,1
		SHL	DI,1
		ADD	DI,OFFSET line_table
		PUSH	DI		; usefull later
		MOV	CX,BX
		SUB	CX,AX
		INC	CX
		PUSH	CX		; also usefull later
		MOV	AX,08000H
gst_18:		STOSW
		STOSW
		LOOP	gst_18
;
; Now 'draw' the 3 lines into the line table
;
		MOV	AX,[BP+x1]
		MOV	[t_x1],AX
		MOV	AX,[BP+y1]
		MOV	[t_y1],AX
		MOV	AX,[BP+x2]
		MOV	[t_x2],AX
		MOV	AX,[BP+y2]
		MOV	[t_y2],AX

		CALL	t_line_guts	; draw line from p1 to p2

		MOV	AX,[BP+x3]
		MOV	[t_x1],AX
		MOV	AX,[BP+y3]
		MOV	[t_y1],AX

		CALL	t_line_guts	; draw line from p3 to p2

		MOV	AX,[BP+x1]
		MOV	[t_x2],AX
		MOV	AX,[BP+y1]
		MOV	[t_y2],AX

		CALL	t_line_guts	; draw line from p3 to p1
;
; Now use updated section of line table to
;
		POP	CX		; number of horizontal lines to draw
		POP	SI		; pointer to line table

		POP	DX		; starting y coordinate
		PUSH	CX
		XOR	CX,CX

		MOV	BX,[ega_base]
		CALL	calc_addr	; ES:DI -> screen, CX = x still
		POP	CX

gst_30:		PUSH	CX
		PUSH	DI
		LODSW			; get one x coord
		CLIP	AX,320
		MOV	BX,AX
		LODSW			; get another x coord
		CLIP	AX,320
		XCHG	AX,BX		; AX now less than or equal to BX
		SUB	BX,AX
		INC	BX		; BX = no of pixels to draw across
		MOV	CL,AL
		AND	CL,7		; CL = x AND 7
		MOV	CH,080H
		SHR	CH,CL		; CH = +ve mask
		SHR	AX,1
		SHR	AX,1
		SHR	AX,1
		ADD	DI,AX		; ES:DI -> screen posn
		MOV	AX,[BP+col]
		CALL	do_hline_fwd

		POP	DI
		ADD	DI,40
		POP	CX
		LOOP	gst_30

		POP	ES
		POP	DS
		POP	BP
		RET	14

g_s_tri		ENDP
;
; The guts of the Bresenham line drawer.
;
t_line_guts	PROC	NEAR

; set up stepping for the right directions

		MOV	DX,[t_x1]
		SUB	DX,[t_x2]
		JG	t_line_2	; jump if x1 > x2
		NEG	DX
		MOV	SI,OFFSET t_step_right
		JMP	SHORT t_line_4
t_line_2:	MOV	SI,OFFSET t_step_left
t_line_4:
					; DX = |xdiff|
					; SI = horizontal stepper

		MOV	BX,[t_y1]
		SUB	BX,[t_y2]
		JG	t_line_6	; jump if y1 > y2
		NEG	BX
		MOV	CX,OFFSET t_step_down
		JMP	SHORT t_line_8
t_line_6:	MOV	CX,OFFSET t_step_up
t_line_8:
					; BX = |ydiff|
					; CX = vertical stepper

; determine whether x or y changes more rapidly

		CMP	DX,BX
		JG	t_line_20	; jump if x varys most
		XCHG	BX,DX		; DX = major side, BX = minor side
		XCHG	CX,SI		; SI = always stepper
					; CX = sometimes stepper

t_line_20:	MOV	[step_always],SI
		MOV	[step_sometimes],CX

		MOV	AX,[t_x1]
		MOV	DI,[t_y1]
		SHL	DI,1
		SHL	DI,1
		ADD	DI,OFFSET line_table

		CALL	t_plotter
		XOR	SI,SI		; clear total
		MOV	CX,DX
		JCXZ	t_line_30	; line is of zero length
t_line_24:	ADD	SI,BX
		SAL	SI,1
		CMP	SI,DX
		JNG	t_line_26
		SAR	SI,1
		SUB	SI,DX
		CALL	[step_sometimes]
		JMP	SHORT t_line_28
t_line_26:	SAR	SI,1
t_line_28:	CALL	[step_always]
		CALL	t_plotter
		LOOP	t_line_24

t_line_30:	RET

t_line_guts	ENDP
;
; Plotter for triangle routine
; 
t_plotter	PROC	NEAR

		CMP	DI,OFFSET line_table
		JC	t_do_plot_x
		CMP	DI,OFFSET line_table_end
		JNC	t_do_plot_x

		CMP	WORD PTR [DI],08000H
		JNE	t_do_plot_2
		MOV	[DI],AX
		MOV	[DI+2],AX
		RET

t_do_plot_2:	CMP	AX,[DI]
		JGE	t_do_plot_4
		MOV	[DI],AX
t_do_plot_4:	CMP	AX,[DI+2]
		JLE	t_do_plot_x
		MOV	[DI+2],AX
t_do_plot_x:	RET

t_plotter	ENDP
;
; Steppers for use by triangle drawer
;
t_step_right	PROC	NEAR

		INC	AX
		RET

t_step_right	ENDP
;
t_step_left	PROC	NEAR

		DEC	AX
		RET

t_step_left	ENDP
;
t_step_down	PROC	NEAR

		ADD	DI,4
		RET

t_step_down	ENDP
;
t_step_up	PROC	NEAR

		ADD	DI,-4
		RET

t_step_up	ENDP

		ASSUME	DS:data_seg
;...e

;...svoid pascal g_s_update\40\page\41\:0:
;
; void pascal g_s_update(page)
;
g_s_update	PROC	FAR

		POP	DX
		POP	CX
		POP	AX		; page in AL
		PUSH	CX
		PUSH	DX
		CALL	calc_page_seg	; AX = segment of given page
		MOV	CS:[ega_base],AX
		RET

g_s_update	ENDP
;...e
;...svoid pascal g_s_clear\40\col\41\:0:
;
; void pascal g_s_clear(col)
;
g_s_clear	PROC	FAR

		POP	DX
		POP	CX
		POP	AX		; colour in AH
		PUSH	CX
		PUSH	DX
		PUSH	ES
		MOV	DX,CS:[ega_base]
		MOV	ES,DX

		MOV	DX,ega_ctrl
		MOV	AL,bit_mask_reg
		OUT	DX,AL

		INC	DX
		MOV	AL,0FFH		; setting all bits at once
		OUT	DX,AL

		MOV	AL,AH		; colour into AL too
		XOR	DI,DI		; start at top of screen
		MOV	CX,200 * 20	; 200 lines * 20 words per line
		REP	STOSW		; fill it
		POP	ES
		RET

g_s_clear	ENDP
;...e
;...svoid pascal g_s_copy\40\page_from\44\ page_to\41\:0:
;
; void pascal g_s_copy(page_from, page_to)
;
page_from	= 8
page_to		= 6
;
g_s_copy	PROC	FAR

		PUSH	BP
		MOV	BP,SP
		PUSH	DS
		PUSH	ES
		MOV	AX,[BP+page_from]
		CALL	calc_page_seg
		MOV	DS,AX
		MOV	AX,[BP+page_to]
		CALL	calc_page_seg
		MOV	ES,AX
		CALL	copy_screen
		POP	ES
		POP	DS
		POP	BP
		RET	4

g_s_copy	ENDP
;...e

;...scopy_screen:0:
;
; Copy a screen from one page to another
;
copy_screen	PROC	NEAR

		XOR	SI,SI
		XOR	DI,DI

		EGAMODE	1

		MOV	CX,8000
		REP	MOVSB

		EGAMODE	2

		RET

copy_screen	ENDP
;...e
;...scalc_page_seg:0:
;
; Calculate segment value for a given page
;
; Input:	AX = page number
; Output:	AX = segment of required page
;
calc_page_seg	PROC	NEAR

					; each page requires 512 paragraphs
		XCHG	AL,AH		; AX = page * 256
		SHL	AH,1		; AX = page * 512
		ADD	AX,seg_ega
		RET

calc_page_seg	ENDP
;...e
;...splot_guts:0:
;
; Do the actual plotting
;
; Input:	(CX,DX) = position, AX = colour
;
plot_guts	PROC	NEAR

		MOV	BX,CS:[ega_base]
		CALL	calc_addr	; ES:DI -> address
					; CX = x still

		AND	CL,7		; number of times to mask right

		MOV	DX,ega_ctrl
		MOV	AL,bit_mask_reg
		OUT	DX,AL

		MOV	AL,080H		; mask for plotting
		SHR	AL,CL		; positioned in correct place

		INC	DX
		OUT	DX,AL

		MOV	CH,ES:[DI]	; set latches
		MOV	ES:[DI],AH	; write data
		RET

plot_guts	ENDP
;...e
;...sline_guts:0:
;
; The guts of the Bresenham line drawer.
;
; Input:	AX --> plotter
;		BP --> stack frame containing variables below
;
x1		= 14
y1		= 12
x2		= 10
y2		= 8
col		= 6
;
; Uses:		ES:DI -> address, CH = positive mask, AH = col, AL = bitmask
;
line_guts	PROC	NEAR

		MOV	CS:[plotter],AX

		MOV	DX,ega_ctrl
		MOV	AL,bit_mask_reg
		OUT	DX,AL

		MOV	AX,[BP+col]

; calculate screen position

		MOV	CX,[BP+x1]
		MOV	CS:[current_x],CX
		MOV	DX,[BP+y1]
		MOV	CS:[current_y],DX
		MOV	BX,CS:[ega_base]
		CALL	calc_addr	; ES:DI -> address
					; CX = x still

		AND	CL,007H
		MOV	AL,080H
		SHR	AL,CL

; set up stepping for the right directions

		MOV	DX,[BP+x1]
		SUB	DX,[BP+x2]
		JG	line_2		; jump if x1 > x2
		NEG	DX
		MOV	SI,OFFSET step_right
		JMP	SHORT line_4
line_2:		MOV	SI,OFFSET step_left
line_4:
					; DX = |xdiff|
					; SI = horizontal stepper

		MOV	BX,[BP+y1]
		SUB	BX,[BP+y2]
		JG	line_6		; jump if y1 > y2
		NEG	BX
		MOV	CX,OFFSET step_down
		JMP	SHORT line_8
line_6:		MOV	CX,OFFSET step_up
line_8:
					; BX = |ydiff|
					; CX = vertical stepper

; determine whether x or y changes more rapidly

		CMP	DX,BX
		JG	line_20		; jump if x varys most
		XCHG	BX,DX		; DX = major side, BX = minor side
		XCHG	CX,SI		; SI = always stepper
					; CX = sometimes stepper

line_20:	MOV	CS:[step_always],SI
		MOV	CS:[step_sometimes],CX

		CALL	CS:[plotter]
		XOR	SI,SI		; clear total
		MOV	CX,DX
		JCXZ	line_30		; line is of zero length
line_24:	ADD	SI,BX
		SAL	SI,1
		CMP	SI,DX
		JNG	line_26
		SAR	SI,1
		SUB	SI,DX
		CALL	CS:[step_sometimes]
		JMP	SHORT line_28
line_26:	SAR	SI,1
line_28:	CALL	CS:[step_always]
		CALL	CS:[plotter]
		LOOP	line_24

line_30:	RET

line_guts	ENDP
;...e
;...splot_and_line:0:
;
; Plotter with option of drawing a line to a column
;
plot_and_line	PROC	NEAR

		PUSH	BX
		PUSH	DX
		MOV	BX,CS:[current_y]
		CMP	BX,CS:[last_filled]
		JNZ	pal_do_it
		MOV	DX,ega_data
		OUT	DX,AL		; set bit for writing
		MOV	DL,ES:[DI]	; set latches
		MOV	ES:[DI],AH	; write colour
		POP	DX
		POP	BX
		RET

pal_do_it:	MOV	CS:[last_filled],BX
		PUSH	DI
		PUSH	CX
		PUSH	AX
		MOV	CX,CS:[current_x]
		MOV	BX,CS:[x_lim]
		SUB	BX,CX
		INC	BX
		MOV	CH,AL
		CALL	do_hline_fwd
		POP	AX
		POP	CX
		POP	DI
		POP	DX
		POP	BX
		RET

plot_and_line	ENDP
;...e
;...sline_and_plot:0:
;
; Plotter with option of drawing a line from a column
;
line_and_plot	PROC	NEAR

		PUSH	BX
		PUSH	DX
		MOV	BX,CS:[current_y]
		CMP	BX,CS:[last_filled]
		JNZ	lap_do_it
		MOV	DX,ega_data
		OUT	DX,AL		; set bit for writing
		MOV	DL,ES:[DI]	; set latches
		MOV	ES:[DI],AH	; write colour
		POP	DX
		POP	BX
		RET

lap_do_it:	MOV	CS:[last_filled],BX
		PUSH	DI
		PUSH	CX
		PUSH	AX
		MOV	CX,CS:[current_x]
		MOV	BX,CS:[x_lim]
		SUB	BX,CX
		NEG	BX		; BX = no of pixels
		INC	BX
		MOV	CH,AL		; CH = +ve mask, CL = LOW x
		CALL	do_hline_bwd
		POP	AX
		POP	CX
		POP	DI
		POP	DX
		POP	BX
		RET

line_and_plot	ENDP
;...e
;...splot:0:
;
; Plotter for use by line drawer
;
plot		PROC	NEAR

		PUSH	DX
		MOV	DX,ega_data
		OUT	DX,AL		; set bit for writing
		MOV	DL,ES:[DI]	; set latches
		MOV	ES:[DI],AH	; write colour
		POP	DX
		RET

plot		ENDP
;...e
;...sunplot:0:
;
; Un-plotter for use by line drawer
;
unplot		PROC	NEAR

		MOV	AH,[DI]
		MOV	ES:[DI],AH
		RET

unplot		ENDP
;...e
;...srect_guts:0:
;
; Do the actual hard work of drawing a rectangle
;
; Input:	BP -> frame
;		(CX,DX) = coordinate of top left too
;
x1		= 14
y1		= 12
x2		= 10
y2		= 8
col		= 6
;
rect_guts	PROC	NEAR
	
		MOV	BX,CS:[ega_base]
		CALL	calc_addr	; ES:DI -> address
		MOV	AX,[BP+col]	; get colour into AH
		MOV	BX,[BP+y1]
rg_line:	MOV	CX,[BP+x1]
		PUSH	BX
		MOV	BX,[BP+x2]
		PUSH	DI		; store screen address
		SUB	BX,CX		; BX = no. pixels left
		INC	BX
		AND	CL,007H		; CL = x coordinate AND 7
		MOV	CH,080H
		SHR	CH,CL		; CH = positive mask
		CALL	do_hline_fwd	; do a line on the screen
		POP	DI		; restore screen address
		POP	BX		; restore y
		ADD	DI,40		; move to next line
		INC	BX		; have moved down a line
		CMP	BX,[BP+y2]	; compare y2 - while not all lines done
		JBE	rg_line
		RET

rect_guts	ENDP
;...e
;...sdo_hline_fwd:0:
;
; Input:	CH=+ve mask, CL = x AND 7
;		BX=no of pixels, ES:DI -> screen, AH=col
;
do_hline_fwd	PROC	NEAR

;
; the process of doing one line consists of :-
;
;	while ( !byte_boundary || finished )
;   		plot_pixel;
;	if ( !finished )
;		{
;		while ( > 8 to go )
;			plot_8_pixels_in_one_go;
;		plot_whats_left;
;		}
;
		MOV	DX,ega_ctrl
		MOV	AL,bit_mask_reg
		OUT	DX,AL

		INC	DX		; move to bit mask port no.

		AND	BX,BX		; zero pixels left?
		JZ	dhzf_done	; if so, must have been a short line

		MOV	AL,CH		; get mask into AL

		TEST	CL,007H		; on a byte boundary?
		JZ	dhzf_byte_bound	; yes, start doing optimised writes

dhzf_again:	OUT	DX,AL		; select bits

		MOV	CH,ES:[DI]	; set latches
		MOV	ES:[DI],AH	; set colour
		ROR	AL,1		; move right

		INC	CL
		DEC	BX		; one less pixel to draw
		JZ	SHORT dhzf_done	; if at least one left to draw loop
		TEST	CL,007H		; on the byte boundary yet?
		JNZ	dhzf_again	; do another pixel
		INC	DI		; move on from first byte

dhzf_byte_bound:
		MOV	AL,0FFH
		OUT	DX,AL		; specify plotting 8 pixels at a time

		MOV	CX,BX
		SHR	CX,1
		SHR	CX,1
		SHR	CX,1		; CX = number of bytes to fill
		MOV	AL,AH
		REP	STOSB		; store 8 pixels in one go
		AND	BL,007H		; any pixels still left to draw?
		JZ	dhzf_done
		MOV	CL,BL
		MOV	BX,0FF00H
		SHR	BX,CL
		MOV	AL,BL		; create mask for whats left in AL
		OUT	DX,AL		; specify rest of pixels
		MOV	CH,ES:[DI]	; set latches
		MOV	ES:[DI],AH	; add in new pixels
dhzf_done:	RET

do_hline_fwd	ENDP
;...e
;...sdo_hline_bwd:0:
;
; Input:	CH=+ve mask, CL = x AND 7
;		BX=no of pixels, ES:DI -> screen, AH=col
;
do_hline_bwd	PROC	NEAR

		MOV	DX,ega_ctrl
		MOV	AL,bit_mask_reg
		OUT	DX,AL

		INC	DX		; move to bit mask port no.

		AND	BX,BX		; zero pixels left?
		JZ	dhzb_done	; if so, must have been a short line

		MOV	AL,CH		; get mask into AL

		AND	CL,007H
		CMP	CL,007H		; on a byte boundary?
		JZ	dhzb_byte_bound	; yes, start doing optimised writes

dhzb_again:	OUT	DX,AL		; select bits

		MOV	CH,ES:[DI]	; set latches
		MOV	ES:[DI],AH	; set colour
		ROL	AL,1		; move left

		DEC	CL
		DEC	BX		; one less pixel to draw
		JZ	SHORT dhzb_done	; if at least one left to draw loop
		AND	CL,007H
		CMP	CL,007H		; on the byte boundary yet?
		JNZ	dhzb_again	; do another pixel
		DEC	DI		; move on from first byte

dhzb_byte_bound:
		MOV	AL,0FFH
		OUT	DX,AL		; specify plotting 8 pixels at a time

		MOV	CX,BX
		SHR	CX,1
		SHR	CX,1
		SHR	CX,1		; CX = number of bytes to fill
		MOV	AL,AH
		STD
		REP	STOSB		; store 8 pixels in one go
		CLD
		AND	BL,007H		; any pixels still left to draw?
		JZ	dhzb_done
		MOV	CL,BL
		MOV	BX,000FFH
		SHL	BX,CL
		MOV	AL,BH		; create mask for whats left in AL
		OUT	DX,AL		; specify rest of pixels
		MOV	CH,ES:[DI]	; set latches
		MOV	ES:[DI],AH	; add in new pixels
dhzb_done:	RET

do_hline_bwd	ENDP
;...e

;...svoid pascal g_l_plot\40\d\44\ x\44\ y\44\ col\41\:0:
;
; void pascal g_l_plot(d, x, y, col)
;
d		= 12
y		= 10
x		= 8
col		= 6
;
g_l_plot	PROC	FAR

		PUSH	BP
		MOV	BP,SP
		PUSH	ES
		MOV	CX,[BP+x]
		MOV	DX,[BP+y]
		MOV	AX,[BP+col]

		PUSH	DS
		MOV	BX,SEG data_seg
		MOV	DS,BX
		MOV	SI,[item_ptr]
		MOV	[SI+item_type],t_plot
		MOV	BX,[BP+d]
		CALL	store_dist
		MOV	[SI+item_min_x],CX
		MOV	[SI+item_max_x],CX
		MOV	[SI+item_min_y],DX
		MOV	[SI+item_max_y],DX
		ADD	SI,TYPE item
		MOV	[item_ptr],SI
		POP	DS

		CALL	plot_guts
		POP	ES
		POP	BP
		RET	8

g_l_plot	ENDP
;...e
;...svoid pascal g_l_line\40\d\44\ x1\44\ y1\44\ x2\44\ y2\44\ col\41\:0:
;
; void pascal g_l_line(d, x1, y1, x2, y2, col)
;
d		= 16
x1		= 14
y1		= 12
x2		= 10
y2		= 8
col		= 6
;
g_l_line	PROC	FAR

		PUSH	BP
		MOV	BP,SP
		PUSH	ES

		PUSH	DS
		MOV	BX,SEG data_seg
		MOV	DS,BX
		MOV	SI,[item_ptr]
		MOV	[SI+item_type],t_line
		MOV	BX,[BP+d]
		CALL	store_dist

		MOV	CX,[BP+x1]
		MOV	[SI+item_x1],CX
		MOV	DX,[BP+x2]
		MOV	[SI+item_x2],DX
		CMP	CX,DX
		JC	g_l_l_2
		XCHG	CX,DX
g_l_l_2:	MOV	[SI+item_min_x],CX
		MOV	[SI+item_max_x],DX

		MOV	CX,[BP+y1]
		MOV	[SI+item_y1],CX
		MOV	DX,[BP+y2]
		MOV	[SI+item_y2],DX
		CMP	CX,DX
		JC	g_l_l_4
		XCHG	CX,DX
g_l_l_4:	MOV	[SI+item_min_y],CX
		MOV	[SI+item_max_y],DX

		ADD	SI,TYPE item
		MOV	[item_ptr],SI
		POP	DS

		MOV	AX,OFFSET plot
		CALL	line_guts
		POP	ES
		POP	BP
		RET	12

g_l_line	ENDP
;...e
;...svoid pascal g_l_diag_vert\40\d\44\ x\44\ x1\44\ y1\44\ x2\44\ y2\44\ col\41\:0:
;
; void pascal g_l_diag_vert(d, x1, y1, x2, y2, x, col)
;
d		= 18
x		= 16
x1		= 14
y1		= 12
x2		= 10
y2		= 8
col		= 6
;
g_l_diag_vert	PROC	FAR

		PUSH	BP
		MOV	BP,SP
		PUSH	ES

		PUSH	DS
		MOV	BX,SEG data_seg
		MOV	DS,BX
		MOV	SI,[item_ptr]
		MOV	[SI+item_type],t_diag_vert
		MOV	BX,[BP+d]
		CALL	store_dist

		MOV	CX,[BP+x1]
		MOV	[SI+item_x1],CX
		MOV	DX,[BP+x2]
		MOV	[SI+item_x2],DX
		CMP	CX,DX
		JC	gldv_2
		MOV	CX,DX
gldv_2:		MOV	[SI+item_min_x],CX
		MOV	DX,[BP+x]
		MOV	[SI+item_max_x],DX

		MOV	CX,[BP+y1]
		MOV	[SI+item_y1],CX
		MOV	DX,[BP+y2]
		MOV	[SI+item_y2],DX
		CMP	CX,DX
		JC	gldv_4
		XCHG	CX,DX
gldv_4:		MOV	[SI+item_min_y],CX
		MOV	[SI+item_max_y],DX

		ADD	SI,TYPE item
		MOV	[item_ptr],SI
		POP	DS

		MOV	AX,[BP+x]
		MOV	CS:[x_lim],AX
		MOV	CS:[last_filled],-1
		MOV	AX,OFFSET plot_and_line
		CALL	line_guts
		POP	ES
		POP	BP
		RET	14

g_l_diag_vert	ENDP
;...e
;...svoid pascal g_l_vert_diag\40\d\44\ x\44\ x1\44\ y1\44\ x2\44\ y2\44\ col\41\:0:
;
; void pascal g_l_vert_diag(x1, y1, x2, y2, x, col)
;
d		= 18
x		= 16
x1		= 14
y1		= 12
x2		= 10
y2		= 8
col		= 6
;
g_l_vert_diag	PROC	FAR

		PUSH	BP
		MOV	BP,SP
		PUSH	ES

		PUSH	DS
		MOV	BX,SEG data_seg
		MOV	DS,BX
		MOV	SI,[item_ptr]
		MOV	[SI+item_type],t_vert_diag
		MOV	BX,[BP+d]
		CALL	store_dist

		MOV	CX,[BP+x1]
		MOV	[SI+item_x1],CX
		MOV	DX,[BP+x2]
		MOV	[SI+item_x2],DX
		CMP	CX,DX
		JC	glvd_2
		MOV	DX,CX
glvd_2:		MOV	CX,[BP+x]
		MOV	[SI+item_min_x],CX
		MOV	[SI+item_max_x],DX

		MOV	CX,[BP+y1]
		MOV	[SI+item_y1],CX
		MOV	DX,[BP+y2]
		MOV	[SI+item_y2],DX
		CMP	CX,DX
		JC	glvd_4
		XCHG	CX,DX
glvd_4:		MOV	[SI+item_min_y],CX
		MOV	[SI+item_max_y],DX

		ADD	SI,TYPE item
		MOV	[item_ptr],SI
		POP	DS

		MOV	AX,[BP+x]
		MOV	CS:[x_lim],AX
		MOV	CS:[last_filled],-1
		MOV	AX,OFFSET line_and_plot
		CALL	line_guts
		POP	ES
		POP	BP
		RET	14

g_l_vert_diag	ENDP
;...e
;...svoid pascal g_l_rect\40\d\44\ x1\44\ y1\44\ x2\44\ y2\44\ col\41\:0:
;
; void pascal g_l_rect(d, x1, y1, x2, y2, col)
;
d		= 16
x1		= 14
y1		= 12
x2		= 10
y2		= 8
col		= 6
;
g_l_rect	PROC	FAR

		PUSH	BP
		MOV	BP,SP
		PUSH	ES

		MOV	CX,[BP+x1]	; ensure x1 < x2
		MOV	AX,[BP+x2]
		CMP	CX,AX
		JC	g_l_rect_x_ok
		XCHG	AX,CX
		MOV	[BP+x1],CX
		MOV	[BP+x2],AX
g_l_rect_x_ok:
		MOV	DX,[BP+y1]	; ensure y1 < y2
		MOV	AX,[BP+y2]
		CMP	DX,AX
		JC	g_l_rect_y_ok
		XCHG	AX,DX
		MOV	[BP+y1],DX
		MOV	[BP+y2],AX
g_l_rect_y_ok:

		PUSH	DS
		MOV	BX,SEG data_seg
		MOV	DS,BX
		MOV	SI,[item_ptr]
		MOV	[SI+item_type],t_rect
		MOV	BX,[BP+d]
		CALL	store_dist
		MOV	[SI+item_min_x],CX
		MOV	AX,[BP+x2]
		MOV	[SI+item_max_x],AX
		MOV	[SI+item_min_y],DX
		MOV	AX,[BP+y2]
		MOV	[SI+item_max_y],AX
		ADD	SI,TYPE item
		MOV	[item_ptr],SI
		POP	DS

		CALL	rect_guts
		POP	ES
		POP	BP
		RET	12

g_l_rect	ENDP
;...e
;...svoid pascal g_clear_log\40\\41\:0:
;
; void pascal g_clear_log()
;
g_clear_log	PROC	FAR

		PUSH	DS
		MOV	AX,SEG data_seg
		MOV	DS,AX
		MOV	AX,OFFSET item_table
		MOV	[item_ptr],AX
		POP	DS
		RET

g_clear_log	ENDP
;...e

;...svoid pascal g_clear_spr\40\\41\:0:
;
; void g_clear_spr()
;
g_clear_spr	PROC	FAR

		PUSH	DS
		MOV	AX,SEG data_seg
		MOV	DS,AX
		MOV	AX,OFFSET precalc_table
		MOV	[precalc_ptr],AX
		MOV	AX,OFFSET refresh_table
		MOV	[refresh_ptr],AX
		POP	DS
		RET

g_clear_spr	ENDP
;...e
;...svoid pascal g_precalc\40\d\44\ z\44\ sprite\44\ x\44\ y\41\:0:
;
; void pascal g_precalc(d, sprite, buf, x, y)
;
d		= 14
z		= 12
sprite		= 10
x		= 8
y		= 6
;
g_precalc	PROC	FAR

		PUSH	BP
		MOV	BP,SP
		PUSH	DS
		PUSH	ES

; select sprite to display

		MOV	AX,[BP+sprite]
		XCHG	AH,AL		; * 256
		SHR	AX,1		; * 128
		MOV	SI,AX
		ADD	SI,OFFSET spr_data
		MOV	AX,SEG data_seg
		MOV	DS,AX		; DS:SI -> sprite
		MOV	ES,AX

		MOV	DX,[BP+x]
		CALL	shift_sprite

; calculate mask address

		MOV	CX,[BP+x]
		MOV	DX,[BP+y]
		MOV	BX,SEG data_seg
		CALL	calc_addr	; ES:DI -> mask, CX = x still

		PUSH	DI		; preserve DI for second pass

; now blank relevant part of mask

		XOR	AX,AX
		MOV	DX,40-3		; line down step

REPT	16
		STOSW
		STOSB
		ADD	DI,DX
ENDM

; consider items obscuring it

		MOV	BX,[BP+d]
		MOV	CX,[BP+x]
		MOV	DX,[BP+y]

		CALL	redraw_in_front

		PUSH	DS
		POP	ES		; DS = ES -> data_seg

; now store the calculated data

		MOV	SI,[precalc_ptr]
		MOV	AX,[BP+z]
		MOV	[SI+precalc_d],AX
		MOV	AX,[BP+x]
		MOV	[SI+precalc_x],AX
		MOV	AX,[BP+y]
		MOV	[SI+precalc_y],AX
		POP	DI
		MOV	[SI+precalc_spos],DI
		MOV	BX,CS:[ega_base]
		MOV	[SI+precalc_sseg],BX
		ADD	SI,precalc_mask
		XCHG	DI,SI		; SI -> mask, DI -> precalc_mask

		MOV	BX,OFFSET shifted_data

		MOV	DX,40-3		; line down step

REPT	16

REPT	3
		LODSB			; AL = -ve mask
		NOT	AL		; AL = +ve mask
		MOV	AH,AL		; AH = +ve mask too

		AND	AL,[BX]		; AH = sprite col 0
		INC	BX		; advance to next byte
		STOSB			; store mask
		MOV	AL,AH		; restore AL

		AND	AL,[BX]		; AH = sprite col 1
		INC	BX		; advance to next byte
		STOSB			; store mask
		MOV	AL,AH		; restore AL

		AND	AL,[BX]		; AH = sprite col 2
		INC	BX		; advance to next byte
		STOSB			; store mask
		MOV	AL,AH		; restore AL

		AND	AL,[BX]		; AH = sprite col 3
		INC	BX		; advance to next byte
		STOSB			; store mask
ENDM

		ADD	SI,DX
ENDM

		MOV	[precalc_ptr],DI

		POP	ES
		POP	DS
		POP	BP
		RET	10

g_precalc	ENDP
;
; SI -> sprite source
; DX = x coordinate
;
shift_sprite	PROC	NEAR

		AND	DX,7
		MOV	DI,OFFSET shifted_data
		MOV	CX,16
ss_2:		PUSH	CX
		MOV	CX,4		; 4 colour planes
ss_4:		PUSH	CX
		MOV	CX,DX
		LODSB
		MOV	BH,[SI+3]
		XOR	BL,BL
		JCXZ	ss_7
ss_6:		SHR	AL,1
		RCR	BX,1
		LOOP	ss_6
ss_7:		STOSB
		MOV	[DI+3],BH
		MOV	[DI+7],BL
		POP	CX
		LOOP	ss_4
		ADD	SI,4
		ADD	DI,8
		POP	CX
		LOOP	ss_2
		RET

shift_sprite	ENDP
;...e
;...svoid pascal g_sprites\40\\41\:0:
;
; void pascal g_sprites()
;
; Output all the precalculated sprites in order of depth
;
g_sprites	PROC	FAR

		PUSH	DS
		PUSH	ES

		MOV	AX,SEG data_seg
		MOV	DS,AX

g_sprites_loop:	CALL	make_a_pass	; returns CF if displayed a sprite
		JC	g_sprites_loop

		POP	ES
		POP	DS
		RET

g_sprites	ENDP
;
;
make_a_pass	PROC	NEAR

		XOR	DX,DX		; furthest value of d set silly
		XOR	SI,SI
		MOV	DI,OFFSET precalc_table
map_next:	CMP	DI,[precalc_ptr]
		JZ	map_done	; got to the end of the table
		MOV	AX,[DI+precalc_d]
					; get 'distance' of sprite
		CMP	AX,-1		; -1 flag indicates already displayed
		JZ	map_advance	; if already displayed consider next
		CMP	AX,DX		; is this sprite further than furthest
		JB	map_advance	; if not then skip
		MOV	SI,DI		; remember furthest
		MOV	DX,AX		; remember distance of furthest

map_advance:	ADD	DI,TYPE precalc	; advance to next sprite
		JMP	map_next

map_done:	AND	SI,SI		; did we find any sprites
		JZ	map_all_done	; if not then return error

; We now know the sprite that is furthest back, and therefore should
; be displayed first so that it can be partially obliterated by closer
; sprites.

		MOV	[SI+precalc_d],-1
		CALL	do_sprite
		STC			; signal sprite displayed
		RET

map_all_done:	CLC			; signal failed to write a sprite
		RET

make_a_pass	ENDP
;
;
do_sprite	PROC	NEAR

		MOV	DI,[refresh_ptr]
		MOV	AX,[SI+precalc_x]
		MOV	[DI+refresh_x],AX
		MOV	AX,[SI+precalc_y]
		MOV	[DI+refresh_y],AX
		MOV	BX,[SI+precalc_spos]
		MOV	[DI+refresh_addr],BX
		ADD	DI,TYPE refresh
		MOV	[refresh_ptr],DI
		MOV	AX,[SI+precalc_sseg]
		MOV	ES,AX
		MOV	DI,BX
		ADD	SI,precalc_mask	; DS:SI -> mask and sprite
					; ES:DI -> screen

; select bit mask register

		MOV	DX,ega_ctrl
		MOV	AL,bit_mask_reg
		OUT	DX,AL

		INC	DX

		MOV	BX,000BH	; colours 0,1
		MOV	CX,0D0FH	; colours 2,3

REPT	16

REPT	3
		LODSW			; AL = +ve mask of colour 0
					; AH = +ve mask of colour 1
		OUT	DX,AL		; set bit mask register
		MOV	AL,ES:[DI]	; set latches
		MOV	ES:[DI],BH

		MOV	AL,AH		; AL = +ve mask of colour 1
		OUT	DX,AL		; set bit mask register
		MOV	AL,ES:[DI]	; set latches
		MOV	ES:[DI],BL

		LODSW			; AL = +ve mask of colour 2
					; AH = +ve mask of colour 3
		OUT	DX,AL		; set bit mask register
		MOV	AL,ES:[DI]	; set latches
		MOV	ES:[DI],CH

		MOV	AL,AH		; AL = +ve mask of colour 3
		OUT	DX,AL		; set bit mask register
		MOV	AL,ES:[DI]	; set latches
		MOV	ES:[DI],CL

		INC	DI
ENDM
		ADD	DI,40-3
ENDM
		RET

do_sprite	ENDP
;...e
;...svoid pascal g_unsprite\40\page_from\44\ page_to\44\ x\44\ y\41\:0:
;
; void pascal g_unsprite(page_from, page_to, x, y)
;
page_from	= 12
page_to		= 10
x		= 8
y		= 6
;
g_unsprite	PROC	FAR

		PUSH	BP
		MOV	BP,SP
		PUSH	DS
		PUSH	ES

		MOV	AX,SEG data_seg
		MOV	DS,AX
		MOV	SI,[refresh_ptr]
		MOV	CX,[BP+x]
		MOV	[SI+refresh_x],CX
		MOV	DX,[BP+y]
		MOV	[SI+refresh_y],DX

		MOV	AX,[BP+page_to]
		CALL	calc_page_seg
		MOV	BX,AX
		CALL	calc_addr	; ES:DI -> place to write to
		MOV	[SI+refresh_addr],DI
		ADD	SI,TYPE refresh
		MOV	[refresh_ptr],SI
		MOV	SI,DI		; DS:SI -> place to write from

		MOV	AX,[BP+page_from]
		CALL	calc_page_seg
		MOV	DS,AX		; DS = segment of page_from

		EGAMODE	1

		MOV	BX,40-3		; line down step

REPT	16
		MOVSB
		MOVSB
		MOVSB
		ADD	DI,BX
		MOV	SI,DI
ENDM

		EGAMODE	2

		POP	ES
		POP	DS
		POP	BP
		RET	8

g_unsprite	ENDP
;...e
;...svoid pascal g_refresh\40\page_from\41\:0:
;
; void pascal g_refresh(page_from)
;
; Update those areas of screen that need changing due to sprites
; Do this top down so as to reduce flicker
;
g_refresh	PROC	FAR

		POP	DX
		POP	CX
		POP	BX		; get page_from
		PUSH	CX
		PUSH	DX
		PUSH	DS
		PUSH	ES
		PUSH	BP

		EGAMODE	1

		MOV	AX,SEG data_seg
		MOV	DS,AX

		MOV	AX,BX
		CALL	calc_page_seg
		MOV	BP,AX		; AX = source segment
		MOV	BX,seg_ega
		MOV	ES,BX		; ES = destination segment

		MOV	BX,-1
		MOV	[prev_x],BX
		MOV	[prev_y],BX

g_refresh_loop:	CALL	find_highest	; returns ZF if no more
		JZ	g_refresh_done
		MOV	AX,[prev_x]
		CMP	AX,[SI+refresh_x]
		JNZ	g_refresh_do
		MOV	BX,[prev_y]
		CMP	BX,[SI+refresh_y]
		JZ	g_refresh_loop	; done this exact area before
g_refresh_do:	MOV	[prev_x],AX
		MOV	[prev_y],BX
		MOV	[SI+refresh_x],-1
		CALL	refresh_sprite
		JMP	g_refresh_loop

g_refresh_done:

		EGAMODE	2

		POP	BP
		POP	ES
		POP	DS
		RET

g_refresh	ENDP
;
;
find_highest	PROC	NEAR

		MOV	CX,0FFFFH	; lowest value of x set silly
		MOV	DX,0FFFFH	; lowest value of y set silly
		XOR	SI,SI
		MOV	DI,OFFSET refresh_table
fh_next:	CMP	DI,[refresh_ptr]
		JZ	fh_done		; got to the end of the table
		MOV	AX,[DI+refresh_x]
		CMP	AX,-1		; -1 flag indicates already displayed
		JZ	fh_advance	; if already displayed consider next
		MOV	BX,[DI+refresh_y]
		CMP	BX,DX		; is this sprite higher than highest
		JA	fh_advance	; if lower then forget it
		JB	fh_yes		; if higher then remember it
		CMP	AX,CX		; else consider x's
		JA	fh_advance	; if to the right of highest forget it

fh_yes:		MOV	SI,DI		; remember highest
		MOV	CX,AX		; remember x
		MOV	DX,BX		; remember y

fh_advance:	ADD	DI,TYPE refresh	; advance to next sprite
		JMP	fh_next

fh_done:	AND	SI,SI		; did we find any sprites
		RET

find_highest	ENDP
;
;
refresh_sprite	PROC	NEAR

		PUSH	DS
		MOV	SI,[SI+refresh_addr]
		MOV	DI,SI		; SI = DI -> screen
		MOV	AX,BP
		MOV	DS,AX		; DS:SI -> source, ES:DI -> destination

		MOV	BX,40-3		; line down step

					; note: already in EGA mode 1
REPT	16
		MOVSB
		MOVSB
		MOVSB
		ADD	DI,BX
		MOV	SI,DI
ENDM

		POP	DS
		RET

refresh_sprite	ENDP
;...e

;...sstore_dist:0:
;
; Store the distance factor
;
; Input:	BX = distance in yyyyyyyyzzzzxxxx format
;
store_dist	PROC	NEAR

		MOV	[SI+item_dy],BH
		MOV	BH,BL
		AND	BH,0F0H
		MOV	[SI+item_dz],BH
		AND	BL,00FH
		MOV	[SI+item_dx],BL
		RET

store_dist	ENDP
;...e
;...sclip_test:0:
;
; Determine whether clipping is to apply
;
; Input:	BX = sprite distance factor in yyyyyyyyzzzzxxxx format
;		[SI+item_d?], ? = x,y,z set up
; Output:	CF set if should clip
;
;	RULE:	if z(item) < z(sprite) then clip
;		else if z(item) > z(sprite) then dont
;		else if x(item) < x(sprite) and
;			y(item) < y(sprite) then clip
;		else dont
;
clip_test	PROC	NEAR

		MOV	AL,BL
		AND	AL,0F0H
		CMP	[SI+item_dz],AL
		JNZ	ct_x
		MOV	AL,BL
		AND	AL,00FH
		CMP	[SI+item_dx],AL
		JNC	ct_x
		CMP	[SI+item_dy],BH
ct_x:		RET

clip_test	ENDP
;...e
;...sredrawing in the mask:0:
;
; Redraw bits that are in front of the area we are interested in
;
; Input:	(CX,DX) = top left of sprite, BX = d
;
redraw_in_front	PROC	NEAR

		PUSH	DS
		MOV	AX,SEG data_seg
		MOV	DS,AX
		MOV	SI,OFFSET item_table
r_i_f_next:	CMP	SI,[item_ptr]
		JZ	r_i_f_done
		CALL	clip_test
		JNC	r_i_f_advance	; no clipping
		CMP	CX,[SI+item_max_x]
		JA	r_i_f_advance	; sprite is beyond right edge
		CMP	DX,[SI+item_max_y]
		JA	r_i_f_advance	; sprite is below bottom edge
		MOV	AX,CX
		ADD	AX,16
		CMP	AX,[SI+item_min_x]
		JB	r_i_f_advance	; sprite is before left edge
		MOV	AX,DX
		ADD	AX,16
		CMP	AX,[SI+item_min_y]
		JB	r_i_f_advance	; sprite is above top edge
		PUSH	BX
		PUSH	CX
		PUSH	DX
		PUSH	SI
		MOV	AL,[SI+item_type]
		SHL	AL,1
		XOR	AH,AH
		MOV	DI,OFFSET jmp_tab
		ADD	DI,AX
		CALL	[DI]
		POP	SI
		POP	DX
		POP	CX
		POP	BX
r_i_f_advance:	ADD	SI,TYPE item
		JMP	r_i_f_next

r_i_f_done:	POP	DS
		RET

redraw_in_front	ENDP
;
;
mask_plot	PROC	NEAR

		MOV	CX,[SI+item_min_x]
		MOV	DX,[SI+item_min_y]
		CALL	m_plot_guts
		RET

mask_plot	ENDP
;
mask_line	PROC	NEAR

		POP	DX
		PUSH	[SI+item_x1]
		PUSH	[SI+item_y1]
		PUSH	[SI+item_x2]
		PUSH	[SI+item_y2]
		PUSH	DX
		PUSH	BP
		MOV	BP,SP
		SUB	BP,2		; no return address segment
		MOV	AX,OFFSET m_plot
		CALL	m_line_guts
		POP	BP
		RET	8

mask_line	ENDP
;
mask_diag_vert	PROC	NEAR

		POP	DX
		MOV	AX,[SI+item_max_x]
		MOV	CS:[x_lim],AX
		MOV	CS:[last_filled],-1
		PUSH	[SI+item_x1]
		PUSH	[SI+item_y1]
		PUSH	[SI+item_x2]
		PUSH	[SI+item_y2]
		PUSH	DX
		PUSH	BP
		MOV	BP,SP
		SUB	BP,2		; no return address segment
		MOV	AX,OFFSET m_plot_and_line
		CALL	m_line_guts
		POP	BP
		RET	8

mask_diag_vert	ENDP
;
mask_vert_diag	PROC	NEAR

		POP	DX
		MOV	AX,[SI+item_min_x]
		MOV	CS:[x_lim],AX
		MOV	CS:[last_filled],-1
		PUSH	[SI+item_x1]
		PUSH	[SI+item_y1]
		PUSH	[SI+item_x2]
		PUSH	[SI+item_y2]
		PUSH	DX
		PUSH	BP
		MOV	BP,SP
		SUB	BP,2		; no return address segment
		MOV	AX,OFFSET m_line_and_plot
		CALL	m_line_guts
		POP	BP
		RET	8

mask_vert_diag	ENDP
;
mask_rect	PROC	NEAR

		POP	BX
		MOV	CX,[SI+item_min_x]
		MOV	DX,[SI+item_min_y]
		PUSH	CX
		PUSH	DX
		PUSH	[SI+item_max_x]
		PUSH	[SI+item_max_y]
		PUSH	BX
		PUSH	BP
		MOV	BP,SP
		SUB	BP,2		; no return address segment
		CALL	m_rect_guts
		POP	BP
		RET	8

mask_rect	ENDP
;...e

;...sm_copy_screen:0:
;
; Copy a screen from one page to another for masks
;
m_copy_screen	PROC	NEAR

		XOR	SI,SI
		XOR	DI,DI
		MOV	CX,4000
		REP	MOVSW
		RET

m_copy_screen	ENDP
;...e
;...sm_plot_guts:0:
;
; Do the actual plotting in the mask
;
; Input:	(CX,DX) = position
;
m_plot_guts	PROC	NEAR

		MOV	BX,SEG data_seg
		CALL	calc_addr	; ES:DI -> address
					; CX = x still

		AND	CL,7		; number of times to mask right

		MOV	CH,080H
		SHR	CH,CL
		OR	ES:[DI],CH	; set pixel
		RET

m_plot_guts	ENDP
;...e
;...sm_line_guts:0:
;
; The guts of the Bresenham line drawer for the mask
;
; Input:	AX --> plotter
;		BP --> stack frame containing variables below
;
x1		= 12
y1		= 10
x2		= 8
y2		= 6
;
; Uses:		ES:DI -> address, CH = positive mask, AH = col, AL = bitmask
;
m_line_guts	PROC	NEAR

		MOV	CS:[plotter],AX

; calculate screen position

		MOV	CX,[BP+x1]
		MOV	CS:[current_x],CX
		MOV	DX,[BP+y1]
		MOV	CS:[current_y],DX
		MOV	BX,SEG data_seg
		CALL	calc_addr	; ES:DI -> address
					; CX = x still

		AND	CL,007H
		MOV	AL,080H
		SHR	AL,CL

; set up stepping for the right directions

		MOV	DX,[BP+x1]
		SUB	DX,[BP+x2]
		JG	m_line_2	; jump if x1 > x2
		NEG	DX
		MOV	SI,OFFSET step_right
		JMP	SHORT m_line_4
m_line_2:	MOV	SI,OFFSET step_left
m_line_4:
					; DX = |xdiff|
					; SI = horizontal stepper

		MOV	BX,[BP+y1]
		SUB	BX,[BP+y2]
		JG	m_line_6	; jump if y1 > y2
		NEG	BX
		MOV	CX,OFFSET step_down
		JMP	SHORT m_line_8
m_line_6:	MOV	CX,OFFSET step_up
m_line_8:
					; BX = |ydiff|
					; CX = vertical stepper

; determine whether x or y changes more rapidly

		CMP	DX,BX
		JG	m_line_20	; jump if x varys most
		XCHG	BX,DX		; DX = major side, BX = minor side
		XCHG	CX,SI		; SI = always stepper
					; CX = sometimes stepper

m_line_20:	MOV	CS:[step_always],SI
		MOV	CS:[step_sometimes],CX

		CALL	CS:[plotter]
		XOR	SI,SI		; clear total
		MOV	CX,DX
		JCXZ	m_line_30	; line is of zero length
m_line_24:	ADD	SI,BX
		SAL	SI,1
		CMP	SI,DX
		JNG	m_line_26
		SAR	SI,1
		SUB	SI,DX
		CALL	CS:[step_sometimes]
		JMP	SHORT m_line_28
m_line_26:	SAR	SI,1
m_line_28:	CALL	CS:[step_always]
		CALL	CS:[plotter]
		LOOP	m_line_24

m_line_30:	RET

m_line_guts	ENDP
;...e
;...sm_plot_and_line:0:
;
; Plotter with option of drawing a line to a column for a mask
;
m_plot_and_line	PROC	NEAR

		PUSH	BX
		MOV	BX,CS:[current_y]
		CMP	BX,CS:[last_filled]
		JNZ	mpal_do_it
		OR	ES:[DI],AL	; set bit
		POP	BX
		RET

mpal_do_it:	MOV	CS:[last_filled],BX
		PUSH	DI
		PUSH	CX
		PUSH	AX
		MOV	CX,CS:[current_x]
		MOV	BX,CS:[x_lim]
		SUB	BX,CX
		INC	BX
		MOV	CH,AL		; CH = +ve mask, CL = x low
		CALL	m_do_hline_fwd
		POP	AX
		POP	CX
		POP	DI
		POP	BX
		RET

m_plot_and_line	ENDP
;...e
;...sm_line_and_plot:0:
;
; Plotter with option of drawing a line from a column for mask
;
m_line_and_plot	PROC	NEAR

		PUSH	BX
		MOV	BX,CS:[current_y]
		CMP	BX,CS:[last_filled]
		JNZ	mlap_do_it
		OR	ES:[DI],AL	; set pixels
		POP	BX
		RET

mlap_do_it:	MOV	CS:[last_filled],BX
		PUSH	DI
		PUSH	CX
		PUSH	AX
		MOV	CX,CS:[current_x]
		MOV	BX,CS:[x_lim]
		SUB	BX,CX
		NEG	BX		; BX = no of pixels
		INC	BX
		MOV	CH,AL		; CH = +ve mask, CL = LOW x
		CALL	m_do_hline_bwd
		POP	AX
		POP	CX
		POP	DI
		POP	BX
		RET

m_line_and_plot	ENDP
;...e
;...sm_plot:0:
;
; Plotter for use by line drawer on masks
;
m_plot		PROC	NEAR

		OR	ES:[DI],AL	; set pixel
		RET

m_plot		ENDP
;...e
;...sm_rect_guts:0:
;
; Do the actual hard work of drawing a rectangle onto a mask
;
; Input:	BP -> frame
;		(CX,DX) = coordinate of top left too
;
x1		= 12
y1		= 10
x2		= 8
y2		= 6
;
m_rect_guts	PROC	NEAR
	
		MOV	BX,SEG data_seg
		CALL	calc_addr	; ES:DI -> address
		MOV	BX,[BP+y1]
mrg_line:	MOV	CX,[BP+x1]
		PUSH	BX
		MOV	BX,[BP+x2]
		PUSH	DI		; store screen address
		SUB	BX,CX		; BX = no. pixels left
		INC	BX
		AND	CL,007H		; CL = x coordinate AND 7
		MOV	CH,080H
		SHR	CH,CL		; CH = positive mask
		CALL	m_do_hline_fwd	; do a line on the screen
		POP	DI		; restore screen address
		POP	BX		; restore y
		ADD	DI,40		; move to next line
		INC	BX		; have moved down a line
		CMP	BX,[BP+y2]	; compare y2 - while not all lines done
		JBE	mrg_line
		RET

m_rect_guts	ENDP
;...e
;...sm_do_hline_fwd:0:
;
; Input:	CH=+ve mask, CL = x AND 7
;		BX=no of pixels, ES:DI -> screen
;
m_do_hline_fwd	PROC	NEAR

		AND	BX,BX		; zero pixels left?
		JZ	mdhzf_done	; if so, must have been a short line

		MOV	AL,CH		; get mask into AL

		TEST	CL,007H		; on a byte boundary?
		JZ	mdhzf_byte_bound
					; yes, start doing optimised writes

mdhzf_again:	OR	ES:[DI],AL	; set pixel
		ROR	AL,1		; move right

		INC	CL
		DEC	BX		; one less pixel to draw
		JZ	SHORT mdhzf_done
					; if at least one left to draw loop
		TEST	CL,007H		; on the byte boundary yet?
		JNZ	mdhzf_again	; do another pixel
		INC	DI		; move on from first byte

mdhzf_byte_bound:
		MOV	AL,0FFH
		MOV	CX,BX
		SHR	CX,1
		SHR	CX,1
		SHR	CX,1		; CX = number of bytes to fill
		REP	STOSB		; store 8 pixels in one go
		AND	BL,007H		; any pixels still left to draw?
		JZ	mdhzf_done
		MOV	CL,BL
		MOV	BX,0FF00H
		SHR	BX,CL
		OR	ES:[DI],BL	; set pixels
mdhzf_done:	RET

m_do_hline_fwd	ENDP
;...e
;...sm_do_hline_bwd:0:
;
; Input:	CH=+ve mask, CL = x AND 7
;		BX=no of pixels, ES:DI -> screen
;
m_do_hline_bwd	PROC	NEAR

		AND	BX,BX		; zero pixels left?
		JZ	mdhzb_done	; if so, must have been a short line

		MOV	AL,CH		; get mask into AL

		AND	CL,007H
		CMP	CL,007H		; on a byte boundary?
		JZ	mdhzb_byte_bound
					; yes, start doing optimised writes

mdhzb_again:	OR	ES:[DI],AL	; set pixel
		ROL	AL,1		; move left

		DEC	CL
		DEC	BX		; one less pixel to draw
		JZ	SHORT mdhzb_done
					; if at least one left to draw loop
		AND	CL,007H
		CMP	CL,007H		; on the byte boundary yet?
		JNZ	mdhzb_again	; do another pixel
		DEC	DI		; move on from first byte

mdhzb_byte_bound:
		MOV	AL,0FFH
		MOV	CX,BX
		SHR	CX,1
		SHR	CX,1
		SHR	CX,1		; CX = number of bytes to fill
		STD
		REP	STOSB		; store 8 pixels in one go
		CLD
		AND	BL,007H		; any pixels still left to draw?
		JZ	mdhzb_done
		MOV	CL,BL
		MOV	BX,000FFH
		SHL	BX,CL
		OR	ES:[DI],BH	; set pixels
mdhzb_done:	RET

m_do_hline_bwd	ENDP
;...e

;...svoid g_sync\40\\41\:0:
;
; void g_sync()
;
g_sync		PROC	FAR

		PUSH	CX
		MOV	CX,9400
gs_loop:	LOOP	gs_loop		; 17 Cycles
		POP	CX
		RET

g_sync		ENDP
;...e

;...scalc_addr:0:
;
; Calculate address of pixel on screen given by segment BX
;
; Input:	BX = segment of screen, (CX,DX) coordinate
; Output:	ES:DI -> relevant byte
; Corrupts:	BX,DX
;
calc_addr	PROC	NEAR

		MOV	ES,BX
		MOV	BX,CX
		SHR	BX,1
		SHR	BX,1
		SHR	BX,1		; BX = (x/8) range 0-39
		XCHG	DH,DL
		SHR	DX,1
		SHR	DX,1
		SHR	DX,1
		ADD	BX,DX		; BX = (x/8) + y*32
		SHR	DX,1
		SHR	DX,1
		ADD	BX,DX		; BX = (x/8) + y*40
		MOV	DI,BX
		RET

calc_addr	ENDP
;...e
;...scalc_char_addr:0:
;
; Input:	BX = segment, (CX,DX) = coordinates in characters
; Output:	ES:DI -> screen address
;
calc_char_addr	PROC	NEAR

		MOV	ES,BX
		XCHG	DL,DH		; DX = y * 256
		MOV	DI,DX
		SHR	DX,1
		SHR	DX,1		; DX = y * 64
		ADD	DI,DX
		ADD	DI,CX		; DI = y * 320 + y * 2
		RET

calc_char_addr	ENDP
;...e
;...sstepping functions:0:
;
; Steppers for use by line drawer
;
step_right	PROC	NEAR

		INC	CS:[current_x]
		TEST	AL,001H
		JNZ	step_right_2	; into a new byte
		SHR	AL,1
		RET
step_right_2:	MOV	AL,080H
		INC	DI
		RET

step_right	ENDP
;
step_left	PROC	NEAR

		DEC	CS:[current_x]
		TEST	AL,080H
		JNZ	step_left_2	; into a new byte
		SHL	AL,1
		RET
step_left_2:	MOV	AL,001H
		DEC	DI
		RET

step_left	ENDP
;
step_down	PROC	NEAR

		INC	CS:[current_y]
		ADD	DI,40
		RET

step_down	ENDP
;
step_up		PROC	NEAR

		DEC	CS:[current_y]
		ADD	DI,-40
		RET

step_up		ENDP
;...e

EGAG_TEXT	ENDS
;...e
END
