/*

opt.h - Interface to options decoder for command line arguments

This module provides functions to :-

1)	Eliminate all options of the form "-o" from argc and argv.

	Eg: prog -o object	object is part of -o option and should
				really be filtered out with it.

2)	Test for prescence of particular options.

	Eg: prog -x file	opt("x", NULL) would return TRUE.
				opt("x+", &s) could return TRUE.
				opt("f", NULL) would return FALSE.

The option - (hyphen on its own) is valid if - is included in the noarg_opts
string. - is not allowed an argument. All other options MUST be letters.

*/

#ifndef OPT_H
#define	OPT_H

#ifndef BOOLEAN_DEFINED
#define	BOOLEAN_DEFINED
typedef	int BOOLEAN;
#define	TRUE  1
#define	FALSE 0
#endif

#ifndef OPT_C

extern BOOLEAN proc_opt(
	int *argc, char *argv [],
	const char *noarg_opts, const char *arg_opts
	);
				/* eg: proc_opt(&argc, argv, "x", "");       */
				/* Means extract -x option only. There are   */
				/* no options with arguments                 */
extern BOOLEAN opt(const char *s, const char **sp);
				/* Test for option present. opt("x", NULL);  */
				/* Can also extract argument as in           */
				/* opt("x+", &s);                            */

#endif

#endif
