;
; TICK	Hook the tick vector and use it for timing
;
; (C) 3/9/88  A.Key
;
;...sincludes:0:
		INCLUDE	INTDOS.INC
;...e
;...sequates:0:
tick		EQU	008H		; slow timer tick interrupt
;...e
;...sdata_seg:0:
data_seg	SEGMENT	'data'

sccs_id		DB	'@(#)Tick hack  3/9/88', 0

data_seg	ENDS
;...e
;...sTICK_TEXT:0:
TICK_TEXT	SEGMENT PUBLIC 'code'

		ASSUME	CS:TICK_TEXT,DS:data_seg

;...spublics:0:
		PUBLIC	tk_init
		PUBLIC	tk_deinit
		PUBLIC	tk_get_counter
;...e
;...svars:0:
old_ivec	LABEL	DWORD
old_off_ivec	DW	?
old_seg_ivec	DW	?

counter		DW	?
;...e

;...svoid pascal tk_init\40\\41\:0:
;
; void pascal void_init()
;
tk_init		PROC	FAR

		PUSH	BX
		PUSH	DX
		PUSH	ES
		MOV	AL,tick
		DOSCALL	dos_get_ivec	; returned in ES:BX
		MOV	CS:[old_off_ivec],BX
		MOV	CS:[old_seg_ivec],ES
		POP	ES

		PUSH	DS
		MOV	AX,SEG TICK_TEXT
		MOV	DS,AX
		MOV	DX,OFFSET new_isr
		MOV	AL,tick
		DOSCALL	dos_set_ivec	; install hacking patch
		POP	DS
		POP	DX
		POP	BX
		RET

tk_init		ENDP
;...e
;...svoid pascal tk_deinit\40\\41\:0:
;
; void pascal tk_deinit()
;
tk_deinit	PROC	FAR

		PUSH	DX
		PUSH	DS
		MOV	DS,CS:[old_seg_ivec]
		MOV	DX,CS:[old_off_ivec]
		MOV	AL,tick
		DOSCALL	dos_set_ivec	; restore old tick
		POP	DS
		POP	DX
		RET

tk_deinit	ENDP
;...e
;...sint pascal tk_get_counter\40\\41\:0:
;
; int pascal tk_get_counter()
;
tk_get_counter	PROC	FAR

		MOV	AX,CS:[counter]
		RET

tk_get_counter	ENDP
;...e

;...snew_isr:0:
;
; Called from tick interrupt vector at 18.2 Hz
;
; IF = 0 at this point
;
new_isr		PROC	FAR

		INC	CS:[counter]
		JMP	CS:[old_ivec]

new_isr		ENDP
;...e

TICK_TEXT	ENDS
;...e
END
