//
// extent.C - Represent a 'extent' as a crude range of X,Y and Z
//

/*...sincludes:0:*/
#include "extent.h"

/*...vextent\46\h:0:*/
/*...e*/

// Union of 2 extents
Extent operator|(Extent & extl, Extent & extr)
	{
	return Extent(Xyz(Min(extl.xmin.x, extr.xmin.x),
			  Min(extl.xmin.y, extr.xmin.y),
			  Min(extl.xmin.z, extr.xmin.z)),
		      Xyz(Max(extl.xmax.x, extr.xmax.x),
			  Max(extl.xmax.y, extr.xmax.y),
			  Max(extl.xmax.z, extr.xmax.z)));
	}

// Intersection of 2 extents
Extent operator&(Extent & extl, Extent & extr)
	{
	return Extent(Xyz(Max(extl.xmin.x, extr.xmin.x),
			  Max(extl.xmin.y, extr.xmin.y),
			  Max(extl.xmin.z, extr.xmin.z)),
		      Xyz(Min(extl.xmax.x, extr.xmax.x),
			  Min(extl.xmax.y, extr.xmax.y),
			  Min(extl.xmax.z, extr.xmax.z)));
	}

// Do two extents overlap
Boolean operator&&(Extent & extl, Extent & extr)
	{
	return extl.xmax.x > extr.xmin.x &&
	       extl.xmax.y > extr.xmin.y &&
	       extl.xmax.z > extr.xmin.z &&
	       extr.xmax.x > extl.xmin.x &&
	       extr.xmax.y > extl.xmin.y &&
	       extr.xmax.z > extl.xmin.z ;
	}
