//
// extent.h - Represent a 'extent' as a crude range of X,Y and Z
//

#ifndef EXTENT_H
#define	EXTENT_H

/*...sincludes:0:*/
#include "types.h"
#include "xyz.h"

/*...vtypes\46\h:0:*/
/*...vxyz\46\h:0:*/
/*...e*/

class Extent
	{
public:
	Xyz xmin, xmax;
	Extent() : xmin(Xyz(0,0,0)), xmax(Xyz(0,0,0)) {}
	Extent(Xyz xmin, Xyz xmax) : xmin(xmin), xmax(xmax) {}
	Extent(const Extent & e) : xmin(e.xmin), xmax(e.xmax) {}
	~Extent() {}
	};

// Union and isect extents
Extent operator|(Extent & extl, Extent & extr);
Extent operator&(Extent & extl, Extent & extr);

// Is there any overlap between two extents?
Boolean operator&&(Extent & extl, Extent & extr);

#endif
