//
// matrix.h - Matrix tools
//

#ifndef MATRIX_H
#define	MATRIX_H

/*...sincludes:0:*/
#include "types.h"
#include "xyz.h"

/*...vtypes\46\h:0:*/
/*...vxyz\46\h:0:*/
/*...e*/

// Simple 3x3 matrices

class Matrix3
	{
public:
	double m[3][3];
	Matrix3() {}
	Matrix3(const double m[3][3]);
	Matrix3(double m00, double m01, double m02,
		double m10, double m11, double m12,
		double m20, double m21, double m22);
	Matrix3(const Xyz & xyz0, const Xyz & xyz1, const Xyz & xyz2);
	Matrix3 inverse() const;
	};

Matrix3 operator*(const Matrix3 & m1, const Matrix3 & m2);
Xyz operator*(const Matrix3 & m, const Xyz & xyz);

// 4x4 ones used for more general transformations
// These sort of assume the Xyz coordinates have an additional field
// (called W) which gets homogenised out at the end. Hence Matrix4 * Xyz
// can make sense.

class Matrix4
	{
public:
	double m[4][4];
	Matrix4() {}
	Matrix4(const double m[4][4]);
	Matrix4(double m00, double m01, double m02, double m03,
		double m10, double m11, double m12, double m13,
		double m20, double m21, double m22, double m23,
		double m30, double m31, double m32, double m33);
	Matrix4(const Matrix3 & m3);
	};

Matrix4 operator*(const Matrix4 & m1, const Matrix4 & m2);
Xyz operator*(const Matrix4 & m, const Xyz & xyz);

// Particularly useful 4x4 matrix

Matrix4 to_viewport(int w, int h);

#endif
