//
// mr.h - Modular Renderer
//

#ifndef MR_H
#define	MR_H

/*...sincludes:0:*/
#include "types.h"			// Basic types
#include "xyz.h"			// X,Y,Z vector type
#include "rgb.h"			// R,G,B colour vector
#include "matrix.h"			// Matrix
#include "bitmap.h"			// Bitmap
#include "texture.h"			// 3D solid texture block
#include "col.h"			// Colour as a function
#include "surf.h"			// Surface as colours and coefficients
#include "extent.h"			// Enclosing regions of space
#include "oplist.h"			// Rendering Ops and lists of Ops
#include "wire.h"			// Wire frame
#include "polygon.h"			// Polygon rendering
#include "wireh.h"			// Wire frame helpers
#include "polyh.h"			// Polygon helpers
#include "shape.h"			// 3D geometric tracable shapes
#include "view.h"			// Viewpoint
#include "light.h"			// Lights in a scene
#include "progress.h"			// Progress indicators
#ifdef WIN32
#include "progwin.h"			// Progress in a Windows window
#endif
#ifdef UNIX
#include "progxwin.h"			// Progress in an XWindows window
#endif
#ifdef OS2
#include "progvio.h"			// Progress in OS/2 Vio fullscreen
#endif
#include "viewer.h"			// Bitmap viewer
#ifdef WIN32
#include "viewwin.h"			// Bitmap viewer in a Windows window
#endif
#ifdef UNIX
#include "viewxwin.h"			// Bitmap viewer in an XWindows window
#endif
#ifdef OS2
#include "viewvio.h"			// Bitmap viewer in OS/2 Vio fullscreen
#endif
#include "raytrace.h"			// Trace a scene

/*...vtypes\46\h:0:*/
/*...vxyz\46\h:0:*/
/*...vrgb\46\h:0:*/
/*...vmatrix\46\h:0:*/
/*...vbitmap\46\h:0:*/
/*...vtexture\46\h:0:*/
/*...vcol\46\h:0:*/
/*...vsurf\46\h:0:*/
/*...vextent\46\h:0:*/
/*...voplist\46\h:0:*/
/*...vwire\46\h:0:*/
/*...vpolygon\46\h:0:*/
/*...vwireh\46\h:0:*/
/*...vpolyh\46\h:0:*/
/*...vshape\46\h:0:*/
/*...vview\46\h:0:*/
/*...vlight\46\h:0:*/
/*...vprogress\46\h:0:*/
/*...vprogwin\46\h:0:*/
/*...vprogxwin\46\h:0:*/
/*...vprogvio\46\h:0:*/
/*...vviewer\46\h:0:*/
/*...vviewwin\46\h:0:*/
/*...vviewxwin\46\h:0:*/
/*...vviewvio\46\h:0:*/
/*...vraytrace\46\h:0:*/
/*...e*/

#endif
