//
// oplist.h - Rendering Ops and lists of them
//

#ifndef OPLIST_H
#define	OPLIST_H

/*...sincludes:0:*/
#include "types.h"
#include "matrix.h"

/*...vtypes\46\h:0:*/
/*...vmatrix\46\h:0:*/
/*...e*/

/*...sclass Op:0:*/
class Op
	{
public:
	Op *next;
	Op() {}
	virtual ~Op() {}
	virtual Op *copy() const = 0;
	virtual Op *trans  (Xyz t) const = 0;
	virtual Op *trans_x(double t) const = 0;
	virtual Op *trans_y(double t) const = 0;
	virtual Op *trans_z(double t) const = 0;
	virtual Op *rot_x(double angle) const = 0;
	virtual Op *rot_y(double angle) const = 0;
	virtual Op *rot_z(double angle) const = 0;
	virtual Op *scale  (Xyz factor) const = 0;
	virtual Op *scale  (double factor) const = 0;
	virtual Op *scale_x(double factor) const = 0;
	virtual Op *scale_y(double factor) const = 0;
	virtual Op *scale_z(double factor) const = 0;
	virtual Op *mult_matrix(const Matrix3 & m) const = 0;
	virtual Op *mult_matrix(const Matrix4 & m) const = 0;

	// Ooops, lets break the OO paradigm here for speed
	virtual int opcode() const = 0;
	};
/*...e*/

class OpList
	{
protected:
/*...sprotected:8:*/
void append(Op *op)
	{
	op->next = 0;
	if ( first != 0 )
		last->next = op;
	else
		first = op;
	last = op;
	}
void append(const OpList & ol);
/*...e*/
public:
	Op *first, *last;

	OpList();
	OpList(const OpList & ol);
	OpList & operator=(const OpList & ol);
	OpList & operator+=(const OpList & ol);
	~OpList();
	void empty();
	};

#endif
