//
// polyh.C - Polygon helpers
//

/*...sincludes:0:*/
#include "polyh.h"

/*...vpolyh\46\h:0:*/
/*...e*/

/*...sclass PolygonBreaker:0:*/
/*...sclass PolygonBreakerCountDown:0:*/
// Generate vertex numbers (counting down), such as 5,4,3,2,1,0.

class PolygonBreakerCountDown
	{
	int verts[N_POLYGON_VERTEXES];
public:
	PolygonBreakerCountDown()
		{
		for ( int i = 0; i < N_POLYGON_VERTEXES; i++ )
			verts[i] = N_POLYGON_VERTEXES-1-i;
		}
	int *vert_array(int n)
		{ return verts+(N_POLYGON_VERTEXES-n); }
	};

static PolygonBreakerCountDown pbcd;
/*...e*/

class PolygonBreaker
	{
	int n_vertexes;
	PolygonOpList & ol;
	Xyz v0, vl;
public:
	PolygonBreaker(PolygonOpList & ol) : n_vertexes(0), ol(ol) {}
	~PolygonBreaker() {}
	void vertex(const Xyz & v);
	void complete();
	};

void PolygonBreaker::vertex(const Xyz & v)
	{
	switch ( n_vertexes )
		{
		case 0:
			++n_vertexes;
			v0 = v;
			break;
		default:
			++n_vertexes;
			break;
		case N_POLYGON_VERTEXES:
			ol.polygon(N_POLYGON_VERTEXES,
				pbcd.vert_array(N_POLYGON_VERTEXES));
			ol.vertex(v0);
			n_vertexes = 2;
			break;
		}
	ol.vertex(v);
	}

void PolygonBreaker::complete()
	{
	if ( n_vertexes > 2 )
		ol.polygon(n_vertexes, pbcd.vert_array(n_vertexes));
	}
/*...e*/

/*...scuboid:0:*/
void cuboid(
	PolygonOpList & ol,
	double minx, double maxx,
	double miny, double maxy,
	double minz, double maxz
	)
	{
	ol.vertex(Xyz(maxx,maxy,maxz)) // #7
	  .vertex(Xyz(minx,maxy,maxz))
	  .vertex(Xyz(maxx,miny,maxz))
	  .vertex(Xyz(minx,miny,maxz))
	  .vertex(Xyz(maxx,maxy,minz))
	  .vertex(Xyz(minx,maxy,minz))
	  .vertex(Xyz(maxx,miny,minz))
	  .vertex(Xyz(minx,miny,minz)) // #0
	  .polygon(0,4,6,2)
	  .polygon(1,3,7,5)
	  .polygon(0,1,5,4)
	  .polygon(2,6,7,3)
	  .polygon(0,2,3,1)
	  .polygon(4,5,7,6)
	  ;
	}	

void cuboid(
	PolygonOpList & ol,
	double minx, double maxx,
	double miny, double maxy,
	double minz, double maxz,
	int index_x, int index_y, int index_z
	)
	{
	ol.vertex(Xyz(maxx,maxy,maxz)) // #7
	  .vertex(Xyz(minx,maxy,maxz))
	  .vertex(Xyz(maxx,miny,maxz))
	  .vertex(Xyz(minx,miny,maxz))
	  .vertex(Xyz(maxx,maxy,minz))
	  .vertex(Xyz(minx,maxy,minz))
	  .vertex(Xyz(maxx,miny,minz))
	  .vertex(Xyz(minx,miny,minz)) // #0
	  .col(index_x)
	  .polygon(0,4,6,2)
	  .polygon(1,3,7,5)
	  .col(index_y)
	  .polygon(0,1,5,4)
	  .polygon(2,6,7,3)
	  .col(index_z)
	  .polygon(0,2,3,1)
	  .polygon(4,5,7,6)
	  ;
	}	
/*...e*/
/*...s\63\_ell_top\47\bot:0:*/
void x_ell_top(
	PolygonOpList & ol,
	double ry, double rz,
	double x,
	int steps
	)
	{
	PolygonBreaker pb(ol);
	double da = 2.0*PI/steps;
	for ( double a = 0.0; a < 2.0*PI; a += da )
		pb.vertex(Xyz(x, ry*cos(a+da), rz*sin(a+da)));
	pb.complete();
	}

void x_ell_bot(
	PolygonOpList & ol,
	double ry, double rz,
	double x,
	int steps
	)
	{
	PolygonBreaker pb(ol);
	double da = 2.0*PI/steps;
	for ( double a = 0.0; a > -2.0*PI; a -= da )
		pb.vertex(Xyz(x, ry*cos(a-da), rz*sin(a-da)));
	pb.complete();
	}

void y_ell_top(
	PolygonOpList & ol,
	double rx, double rz,
	double y,
	int steps
	)
	{
	PolygonBreaker pb(ol);
	double da = 2.0*PI/steps;
	for ( double a = 0.0; a < 2.0*PI; a += da )
		pb.vertex(Xyz(rx*sin(a+da), y, rz*cos(a+da)));
	pb.complete();
	}

void y_ell_bot(
	PolygonOpList & ol,
	double rx, double rz,
	double y,
	int steps
	)
	{
	PolygonBreaker pb(ol);
	double da = 2.0*PI/steps;
	for ( double a = 0.0; a > -2.0*PI; a -= da )
		pb.vertex(Xyz(rx*sin(a-da), y, rz*cos(a-da)));
	pb.complete();
	}

void z_ell_top(
	PolygonOpList & ol,
	double rx, double ry,
	double z,
	int steps
	)
	{
	PolygonBreaker pb(ol);
	double da = 2.0*PI/steps;
	for ( double a = 0.0; a < 2.0*PI; a += da )
		pb.vertex(Xyz(rx*cos(a+da), ry*sin(a+da), z));
	pb.complete();
	}

void z_ell_bot(
	PolygonOpList & ol,
	double rx, double ry,
	double z,
	int steps
	)
	{
	PolygonBreaker pb(ol);
	double da = 2.0*PI/steps;
	for ( double a = 0.0; a > -2.0*PI; a -= da )
		pb.vertex(Xyz(rx*cos(a-da), ry*sin(a-da), z));
	pb.complete();
	}
/*...e*/
/*...s\63\_ell_cyl:0:*/
void x_ell_cyl(
	PolygonOpList & ol,
	double ry, double rz,
	double minx, double maxx,
	int steps
	)
	{
	double da = 2.0*PI/steps;
	ol.vertex(Xyz(minx, ry, 0.0))  // #3
	  .vertex(Xyz(maxx, ry, 0.0)); // #2
	for ( double a = 0.0; a < 2.0*PI; a += da )
		ol.vertex(Xyz(minx, ry*cos(a+da), rz*sin(a+da))) // #1
		  .vertex(Xyz(maxx, ry*cos(a+da), rz*sin(a+da))) // #0
		  .polygon(0,2,3,1);
	}

void y_ell_cyl(
	PolygonOpList & ol,
	double rx, double rz,
	double miny, double maxy,
	int steps
	)
	{
	double da = 2.0*PI/steps;
	ol.vertex(Xyz(0.0, miny, rz))  // #3
	  .vertex(Xyz(0.0, maxy, rz)); // #2
	for ( double a = 0.0; a < 2.0*PI; a += da )
		ol.vertex(Xyz(rx*sin(a+da), miny, rz*cos(a+da))) // #1
		  .vertex(Xyz(rx*sin(a+da), maxy, rz*cos(a+da))) // #0
		  .polygon(0,2,3,1);
	}

void z_ell_cyl(
	PolygonOpList & ol,
	double rx, double ry,
	double minz, double maxz,
	int steps
	)
	{
	double da = 2.0*PI/steps;
	ol.vertex(Xyz(rx, 0.0, minz))  // #3
	  .vertex(Xyz(rx, 0.0, maxz)); // #2
	for ( double a = 0.0; a < 2.0*PI; a += da )
		ol.vertex(Xyz(rx*cos(a   ), ry*sin(a   ), minz))
		  .vertex(Xyz(rx*cos(a   ), ry*sin(a   ), maxz))
		  .polygon(0,2,3,1);
	}
/*...e*/
