//
// polyh.h - Polygon helpers
//

#ifndef POLYH_H
#define	POLYH_H

/*...sincludes:0:*/
#include "types.h"
#include "xyz.h"
#include "oplist.h"
#include "polygon.h"

/*...vtypes\46\h:0:*/
/*...vxyz\46\h:0:*/
/*...voplist\46\h:0:*/
/*...vpolygon\46\h:0:*/
/*...e*/

// General polygon cuboid

void cuboid(
	PolygonOpList & ol,
	double minx, double maxx,
	double miny, double maxy,
	double minz, double maxz
	);

void cuboid(
	PolygonOpList & ol,
	double minx, double maxx,
	double miny, double maxy,
	double minz, double maxz,
	int index_x, int index_y, int index_z
	);

#define	N_POLY_STEPS 24

// Generation of polygons to represent the tops and bottoms of elliptical
// cylinders and cones etc. Basically, just generate an ellipse.

void x_ell_top(
	PolygonOpList & ol,
	double ry, double rz,
	double x,
	int steps = N_POLY_STEPS
	);

void x_ell_bot(
	PolygonOpList & ol,
	double ry, double rz,
	double x,
	int steps = N_POLY_STEPS
	);

void y_ell_top(
	PolygonOpList & ol,
	double rx, double rz,
	double y,
	int steps = N_POLY_STEPS
	);

void y_ell_bot(
	PolygonOpList & ol,
	double rx, double rz,
	double y,
	int steps = N_POLY_STEPS
	);

void z_ell_top(
	PolygonOpList & ol,
	double rx, double ry,
	double z,
	int steps = N_POLY_STEPS
	);

void z_ell_bot(
	PolygonOpList & ol,
	double rx, double ry,
	double z,
	int steps = N_POLY_STEPS
	);

// Generation of polygons to represent the curved outer surface of an
// elliptical cylinder.

void x_ell_cyl(
	PolygonOpList & ol,
	double ry, double rz,
	double minx, double maxx,
	int steps = N_POLY_STEPS
	);

void y_ell_cyl(
	PolygonOpList & ol,
	double rx, double rz,
	double miny, double maxy,
	int steps = N_POLY_STEPS
	);

void z_ell_cyl(
	PolygonOpList & ol,
	double rx, double ry,
	double minz, double maxz,
	int steps = N_POLY_STEPS
	);

#endif
