//
// progress.C - Progress indicator
//

/*...sincludes:0:*/
#ifdef NO_CINCLUDES
  #include <string.h>
#else
  #include <cstring>
#endif

#ifndef NO_STDNS
  using namespace std;
#endif

#include "progress.h"

/*...vprogress\46\h:0:*/
/*...e*/

/*...sProgressIgnore:0:*/
ProgressIgnore::ProgressIgnore()
	: Progress()
	{}

ProgressIgnore::~ProgressIgnore() {}

void ProgressIgnore::begin() {}

void ProgressIgnore::done(int sofar, int total) { sofar=sofar; total=total; }

void ProgressIgnore::end() {}

void ProgressIgnore::message(const char *message) { message=message; }
/*...e*/
/*...sProgressTimer:0:*/
static char bs26[] = "\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b";

/*...sstr_of_time:0:*/
static char *str_of_time(time_t t, char *buf)
	{
	strcpy(buf, ctime(&t));
	buf[19] = '\0';
	return buf + 11;
	}
/*...e*/

ProgressTimer::ProgressTimer(ostream & os) : Progress(), os(os) {}

ProgressTimer::~ProgressTimer() {}

void ProgressTimer::begin()
	{
	t_started = time(NULL);
	char buf[30+1];
	os << setiosflags(ios::fixed)
	   << "Started " << str_of_time(t_started, buf)
	   << ",   0.0% done, etc ________ "
	   << flush;
	}

void ProgressTimer::done(int sofar, int total)
	{
	time_t t_fin = t_started + (((time(NULL) - t_started) * total) / sofar);
	double percent = (100.0 * (double) sofar) / (double) total;
	char buf[30+1];
	os << bs26
	   << setw(5) << setprecision(1) << percent
	   << "% done, etc " << str_of_time(t_fin, buf) << " "
	   << flush;
	}

void ProgressTimer::end()
	{
	time_t t_now = time(NULL);
	char buf[30+1];
	os << bs26
	   << ( abort_flag ? "aborted" : "done" )
	   << " at " << str_of_time(t_now, buf)
	   << ", took " << t_now - t_started << "s   "
	   << endl
	   << flush;
	}

void ProgressTimer::message(const char *message)
	{ os << message << endl; }
/*...e*/
