//
// progress.h - Progress mechanism
//
// A raytrace can be a time consuming activity. The raytrace function will
// notify a Progress object of its progress as it goes along. By supplying
// a different version, the user may be kept informed using graphics etc..
//

#ifndef PROGRESS_H
#define	PROGRESS_H

/*...sincludes:0:*/
#ifdef NO_CINCLUDES
  #include <time.h>
  #include <iostream.h>
  #include <iomanip.h>
#else
  #include <ctime>
  #include <iostream>
  #include <iomanip>
#endif

#ifdef NO_STDNS
  #define STDNS
#else
  #define STDNS std::
#endif

#include "types.h"

/*...vtypes\46\h:0:*/
/*...e*/

// All progress indicators are able to abort the trace.

class Progress
	{
protected:
	Boolean abort_flag;
public:
	Progress() : abort_flag(FALSE) {}
	virtual ~Progress() {}
	virtual void begin() = 0;
	virtual void done(int sofar, int total) = 0;
	virtual void end() = 0;
	virtual void message(const char *message) = 0;
	virtual void abort() { abort_flag = TRUE; }
	virtual Boolean aborted() const { return abort_flag; }
	};

// Specific progress indicator that displays nothing

class ProgressIgnore : public Progress
	{
public:
	ProgressIgnore();
	virtual ~ProgressIgnore();
	virtual void begin();
	virtual void done(int sofar, int total);
	virtual void end();
	virtual void message(const char *message);
	};

// Specific progress indicator that displays % done to an output stream.
// Also it uses the system clock to predict the completion time.

class ProgressTimer : public Progress
	{
	time_t t_started;
	STDNS ostream & os;
public:
	ProgressTimer(STDNS ostream & os);
	virtual ~ProgressTimer();
	virtual void begin();
	virtual void done(int sofar, int total);
	virtual void end();
	virtual void message(const char *message);
	};

#endif
