//
// progvio.C - Implement ProgressVio using OS/2 Vio FullScreen
//

/*...sincludes:0:*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include <memory.h>
#include <time.h>
#include <conio.h>

extern "C" {
#include "gbm.h"
#include "gbmerr.h"
}

#include "font.h"
#include "bitmap.h"
#include "progvio.h"

/*...vfont\46\h:0:*/
/*...vbitmap\46\h:0:*/
/*...vprogvio\46\h:0:*/
/*...e*/

/*...sscn:0:*/
#define INCL_BASE
#include <os2.h>

#define	SCN_W 320
#define	SCN_H 200

static VIOMODEINFO vmiOld;
static unsigned char *ptr;

/*...sscn_lock:0:*/
static void scn_lock()
	{
	unsigned char status;
	VioScrLock(VP_WAIT, &status, (HVIO) 0);
	}
/*...e*/
/*...sscn_unlock:0:*/
static void scn_unlock()
	{
	VioScrUnLock((HVIO) 0);
	}
/*...e*/
/*...sscn_cls:0:*/
static void scn_cls()
	{
	memset(ptr, 0, SCN_W*SCN_H);
	}
/*...e*/
/*...sscn_border:0:*/
static void scn_border(Byte border)
	{
	VIOOVERSCAN vioos;
	vioos.cb = sizeof(VIOOVERSCAN);
	vioos.type = 1; /* Apparently no #define for this */
	vioos.color = border;
	VioSetState(&vioos, (HVIO) 0);
	}
/*...e*/
/*...sscn_palette\44\ scn_palette_gbm:0:*/
static void scn_palette(BYTE *palette, int first, int num)
	{
	BYTE *buf = (BYTE *) palette;
	BYTE *_Seg16 buf1616 = (BYTE *_Seg16) buf;
	VIOCOLORREG viocreg;
	viocreg.cb = sizeof(VIOCOLORREG);
	viocreg.type = 3; /* Apparently no #define for this */
	viocreg.firstcolorreg = first;
	viocreg.numcolorregs = num;

	/* Note: viocreg.colorregaddr should be of type CHAR *_Seg16
	   But it isn't! Hence if I say viocreg.colorregaddr = buf,
	   then the correct thunking will not be applied! */
	memcpy(&viocreg.colorregaddr, &buf1616, 4);

	VioSetState(&viocreg, (HVIO) 0);
	}

static void scn_palette_gbm(const GBMRGB gbmrgb[])
	{
	BYTE palette[0x100][3];
	int i;
	for ( i = 0; i < 0x100; i++ )
		{
		palette[i][0] = (gbmrgb[i].r>>2);
		palette[i][1] = (gbmrgb[i].g>>2);
		palette[i][2] = (gbmrgb[i].b>>2);
		}
	scn_palette((BYTE *) palette, 0, 0x100);
	}
/*...e*/
/*...sscn_image:0:*/
static void scn_image(int x, int y, int w, int h, const unsigned char *data)
	{
	int stride = ((w+3)&~3);
	unsigned char *scn = (unsigned char *) ptr + ((y*SCN_W) + x);
	if ( x+w > SCN_W ) w = SCN_W-x;
	if ( y+h > SCN_H ) h = SCN_H-y;
	int i;
	data += (h-1) * stride;
	for ( i = 0; i < h; i++, data -= stride, scn += SCN_W )
		memcpy(scn, data, w);
	}
/*...e*/
/*...sscn_char\44\ scn_string:0:*/
static void scn_char(int x, int y, char c)
	{
	int i, j;
	if ( c < ' ' || c > 127 )
		return;
	for ( j = 0; j < 8; j++ )
		for ( i = 0; i < 8; i++ )
			if ( mr_font[c-' '][j][i] )
				ptr[(y+j)*SCN_W+(x+i)] = 0xff;
//			else
//				ptr[(y+j)*SCN_W+(x+i)] = 0;
	}

static void scn_string(int x, int y, const char *s)
	{
	while ( x+8 <= SCN_W && *s != '\0' )
		{
		scn_char(x, y, *s++);
		x += 8;
		}
	}
/*...e*/
/*...sscn_init:0:*/
static Boolean scn_init()
	{
	VIOMODEINFO vmi;
	VIOPHYSBUF phys;
	unsigned char *_Seg16 ptr1616;

	vmi.cb     = 12;
	vmi.fbType = 3;
	vmi.color  = 8;
	vmi.col    = 40;
	vmi.row    = 25;
	vmi.hres   = SCN_W;
	vmi.vres   = SCN_H;
	VioGetMode(&vmiOld, (HVIO) 0);
	if ( VioSetMode(&vmi, (HVIO) 0) )
		return FALSE;
	phys.cb = 0x10000;
	phys.pBuf = (PBYTE) 0xa0000;
	if ( VioGetPhysBuf(&phys, 0) )
		return FALSE;
	ptr1616 = (unsigned char *_Seg16) ( phys.asel[0] << 16 );
	ptr = (unsigned char *) ptr1616;

	/* Set all palette entrys to black */
	{
	static BYTE palette[0x100][3];
	memset(palette, 0, sizeof(palette));
	scn_palette((BYTE *) palette, 0, 0x100);
	}

	/* Set screen to colour 0, which will get set to black */
	scn_cls();
	return TRUE;
	}
/*...e*/
/*...sscn_term:0:*/
static void scn_term()
	{
	VioSetMode(&vmiOld, (HVIO) 0);
	}
/*...e*/
/*...e*/

#define	N_MESSAGES 8
static int inx_message = 0;
static char *messages[N_MESSAGES];
static int percent;
static GBM *gbm; GBMRGB gbmrgb[0x100]; Byte *data24, *data8;
static time_t t_started = 0, t_fin = 0;

/*...sstr_of_time:0:*/
static char *str_of_time(time_t t, char *buf)
	{
	strcpy(buf, ctime(&t));
	buf[19] = '\0';
	return buf + 11;
	}
/*...e*/
/*...sredraw:0:*/
static void redraw()
	{
	Boolean ok = gbm_errdiff_7R8G4B(gbm, data24, data8);
	scn_lock();
	scn_cls();
	if ( ok ) 
		scn_image(0, 0, gbm->w, gbm->h, data8);
	char s[100+1], buf[40+1];
	if ( t_started != 0 )
		{
		sprintf(s, "Start %s", str_of_time(t_started, buf));
		scn_string(SCN_W-strlen(s)*8,   0, s);
		}
	if ( t_fin != 0 )
		{
		sprintf(s, "Ready %s", str_of_time(t_fin, buf));
		scn_string(SCN_W-strlen(s)*8,   8, s);
		}
	sprintf(s, "%d%% done", percent);
	scn_string(SCN_W-strlen(s)*8, 2*8, s);
	int inx = inx_message;
	for ( int i = 0; i < N_MESSAGES; i++ )
		{
		if ( --inx < 0 )
			inx = N_MESSAGES-1;
		if ( messages[inx] == 0 )
			break;
		scn_string(0, SCN_H-8-i*8, messages[inx]);
		}
	scn_unlock();
	}
/*...e*/

/*...sProgressVio:0:*/
ProgressVio::ProgressVio(Bitmap & b)
	{
	for ( int i = 0; i < N_MESSAGES; i++ )
		messages[i] = 0;
	percent = 0;
	GBMRGB *gbmrgb_dummy; // Dummy
	b.get_gbm_internals(gbm, gbmrgb_dummy, data24);
	gbm_errdiff_pal_7R8G4B(gbmrgb);
	gbmrgb[0xff].r = gbmrgb[0xff].g = gbmrgb[0xff].b = 0xff; // White
	data8 = new Byte[((gbm->w+3)&~3)*gbm->h];
	scn_init();
	scn_palette_gbm(gbmrgb);
	}
/*...e*/
/*...s\126\ProgressVio:0:*/
ProgressVio::~ProgressVio()
	{
	scn_term();
	for ( int i = 0; i < N_MESSAGES; i++ )
		if ( messages[i] )
			delete[] messages[i];
	delete[] data8;
	}
/*...e*/
/*...sbegin:0:*/
void ProgressVio::begin()
	{
	t_started = time(NULL);
	}
/*...e*/
/*...send:0:*/
void ProgressVio::end() {}
/*...e*/
/*...sdone:0:*/
void ProgressVio::done(int sofar, int total)
	{
	t_fin = t_started + (((time(NULL) - t_started) * total) / sofar);
	int old_percent = percent;
	percent = (sofar*100)/total;
	if ( percent > old_percent )
		// Only redraw if a reasonable amount of progress made
		redraw();
	if ( kbhit() && getch() == 0x1b )
		abort();
	}
/*...e*/
/*...smessage:0:*/
void ProgressVio::message(const char *message)
	{
	int len;
	while ( (len = strlen(message)) > 0 )
		{
		if ( len > SCN_W/8 )
			len = SCN_W/8;
		if ( messages[inx_message] )
			delete[] messages[inx_message];
		messages[inx_message] = new char[len+1];
		memcpy(messages[inx_message], message, len);
		messages[inx_message][len] = '\0';
		if ( ++inx_message == N_MESSAGES )
			inx_message = 0;
		message += len;
		}
	redraw();
	}
/*...e*/
