//
// progwin.h - Display Progress using Windows window
//
// The Bitmap being watched must be 24bpp.
// If you use this you'll need to link with gbmerr.lib.
// You'll also need to link with user32.lib and gdi32.lib.
//

#ifndef PROGWIN_H
#define	PROGWIN_H

/*...sincludes:0:*/
#include "types.h"
#include "bitmap.h"
#include "progress.h"

/*...vtypes\46\h:0:*/
/*...vbitmap\46\h:0:*/
/*...vprogress\46\h:0:*/
/*...e*/

class ProgressWinInternal;

class ProgressWin : public Progress
	{
	ProgressWinInternal *pwi;
public:
	enum WinFlags { centralized = 1, minimized = 2 };
	ProgressWin(
		Bitmap & b,
		const char *title = 0,
		WinFlags wf = (WinFlags) 0
		);
	virtual ~ProgressWin();
	virtual void begin();
	virtual void done(int sofar, int total);
	virtual void end();
	virtual void message(const char *message);
	};

#endif
