//
// progxwin.C - Implement ProgressWin using an XWindows window
//

/*...sincludes:0:*/
#ifdef NO_CINCLUDES
  #include <stdio.h>
  #include <stdlib.h>
  #include <string.h>
  #include <time.h>
#else
  #include <cstdio>
  #include <cstdlib>
  #include <cstring>
  #include <ctime>
#endif

#ifndef NO_STDNS
  using namespace std;
#endif

extern "C" {
#include "gbm.h"
#include "gbmerr.h"
}

#include "font.h"
#include "xwin.h"
#include "bitmap.h"
#include "progxwin.h"

/*...vfont\46\h:0:*/
/*...vxwin\46\h:0:*/
/*...vbitmap\46\h:0:*/
/*...vprogxwin\46\h:0:*/
/*...e*/

/*...sstr_of_time:0:*/
static char *str_of_time(time_t t, char *buf)
	{
	strcpy(buf, ctime(&t));
	buf[19] = '\0';
	return buf + 11;
	}
/*...e*/
/*...sclass ProgressXWinInternal:0:*/
#define	N_MESSAGES  8
#define	N_TEXTMODES 4

class ProgressXWinInternal : public XWin
	{
	XImage *ximage;
	Byte pix[0x40];

	GBM *gbm; Byte *data24, *data8;
	int inx_message;
	char *messages[N_MESSAGES];
	int percent;

	time_t t_started, t_fin;

	Boolean show_messages;
	Boolean show_progress;

	void write_char(int x, int y, char c);
	void write_str(int x, int y, const char *s);
	void redraw();

public:
	// Events
	virtual void expose(int x, int y, int w, int h);
	virtual void buttonrelease(int x, int y, int button);
	virtual void keypress(char c);
	virtual void close();

	ProgressXWinInternal(
		Bitmap & b,
		const char *title,
		const char *display,
		const char *geometry
		);
	~ProgressXWinInternal();

	Boolean aborted;

	void begin();
	void done(int sofar, int total);
	void end();
	void message(const char *message);
	};

/*...sfatal:0:*/
static void fatal(const char *message)
	{
	cerr << message << endl;
	exit(1);
	}
/*...e*/

/*...sProgressXWinInternal:0:*/
ProgressXWinInternal::ProgressXWinInternal(
	Bitmap & b,
	const char *title,
	const char *display,
	const char *geometry
	)
	:
	XWin(
		b.width(), b.height(),
		title != 0 ? title : "Raytrace progress",
		display,
		geometry
		),
	show_messages(TRUE),
	show_progress(TRUE),
	t_started(0),
	t_fin(0),
	aborted(FALSE)
	{
	GBMRGB *gbmrgb_dummy; // 24bpp bitmap has no palette
	b.get_gbm_internals(gbm, gbmrgb_dummy, data24);

	for ( int i = 0; i < N_MESSAGES; i++ )
		messages[i] = 0;
	inx_message = 0;
	percent = 0;

	switch ( xdpy->v->c_class )
		{
/*...sTrueColor\44\ DirectColor:16:*/
case TrueColor:
case DirectColor:
	{
	     if ( xdpy->v->red_mask   == 0xff0000 &&
	          xdpy->v->green_mask == 0x00ff00 &&
	          xdpy->v->blue_mask  == 0x0000ff )
		;
	else if ( xdpy->v->red_mask   == 0x0000ff &&
	          xdpy->v->green_mask == 0x00ff00 &&
	          xdpy->v->blue_mask  == 0xff0000 )
		;
	else
		fatal("visual has unsupported red/green/blue masks");
	int xstride = gbm->w*4;
	ximage = XCreateImage(
		xdpy->dpy, xdpy->v,	/* display and visual */
		24,			/* image depth */
		ZPixmap,		/* XImage format */
		0,			/* offset */
		0,			/* data */
		gbm->w, gbm->h,		/* image size in pixels */
		32,			/* scanline alignment */
		0			/* let it work out bytes per line */
		);
	ximage->data = (char *) new Byte[xstride*gbm->h];
	ximage->byte_order = LSBFirst;
	}
	break;
/*...e*/
/*...sPseudoColor:16:*/
case PseudoColor:
	{
	int istride24 = ((gbm->w*24+31)/32)*4;
	int istride8  = ((gbm->w*8 +31)/32)*4;
	int xstride   = gbm->w;
	GBMRGB gbmrgb444[0x100];
	Byte *xdata = new Byte[istride8*gbm->h];
	gbm_errdiff_pal_4R4G4B(gbmrgb444);
	if ( !gbm_errdiff_4R4G4B(gbm, data24, data8) )
		{
		delete[] data8;
		fatal("out of memory");
		}
	for ( int i = 0; i < 0x40; i++ )
		{
		XColor col;
		col.red   = gbmrgb444[i].r * 0x0101;
		col.green = gbmrgb444[i].g * 0x0101;
		col.blue  = gbmrgb444[i].b * 0x0101;
		if ( XAllocColor(xdpy->dpy, DefaultColormap(xdpy->dpy, xdpy->scrn), &col) )
			pix[i] = col.pixel;
		else
			{
			delete[] data8;
			fatal("can't allocate 64 palette entries");
			}
		}
	ximage = XCreateImage(
		xdpy->dpy, xdpy->v,	/* display and visual */
		8,			/* image depth */
		ZPixmap,		/* XImage format */
		0,			/* offset */
		0,			/* data */
		gbm->w, gbm->h,		/* image size in pixels */
		8,			/* scanline alignment */
		0			/* let it work out bytes per line */
		);
	ximage->data = (char *) ( xdata = new Byte[xstride*gbm->h] );
	ximage->byte_order = LSBFirst;
	}
	break;
/*...e*/
/*...sdefault:16:*/
default:
	fatal("can't work with current XWindows visual");
/*...e*/
		}

	redraw();

	XSync(xdpy->dpy, False);
	}
/*...e*/
/*...s\126\ProgressXWinInternal:0:*/
ProgressXWinInternal::~ProgressXWinInternal()
	{
	delete[] ximage->data;
	ximage->data = 0;
	XDestroyImage(ximage);

	switch ( xdpy->v->c_class )
		{
/*...sPseudoColor:16:*/
case PseudoColor:
	{
	unsigned long pixl[0x40];
	for ( int i = 0; i < 0x40; i++ )
		pixl[i] = pix[i];
	XFreeColors(xdpy->dpy, DefaultColormap(xdpy->dpy, xdpy->scrn), pixl, 0x40, 0);
	delete[] data8;
	}
	break;
/*...e*/
		}

	for ( int i = 0; i < N_MESSAGES; i++ )
		if ( messages[i] )
			delete[] messages[i];
	}
/*...e*/

/*...sexpose:0:*/
void ProgressXWinInternal::expose(int x, int y, int w, int h)
	{
	XPutImage(xdpy->dpy, w_bitmap, gc, ximage, x, y, x, y, w, h);
	}
/*...e*/
/*...sbuttonrelease:0:*/
void ProgressXWinInternal::buttonrelease(int x, int y, int button)
	{
	if ( button == 2 )
		aborted = TRUE;
	}
/*...e*/
/*...skeypress:0:*/
void ProgressXWinInternal::keypress(char c)
	{
	switch ( c )
		{
/*...sQ\44\q\44\X\44\x\44\Esc \45\ abort:16:*/
case 'Q':
case 'q':
case 'X':
case 'x':
case 27:
	aborted = TRUE;
	break;
/*...e*/
/*...sM\44\m         \45\ show\47\hide messages:16:*/
case 'M': case 'm':
	show_messages = !show_messages;
	expose(0, 0, gbm->w, gbm->h);
	break;
/*...e*/
/*...sP\44\p         \45\ show\47\hide progress:16:*/
case 'P': case 'p':
	show_progress = !show_progress;
	expose(0, 0, gbm->w, gbm->h);
	break;
/*...e*/
		}
	}
/*...e*/
/*...sclose:0:*/
void ProgressXWinInternal::close()
	{
	aborted = TRUE;
	}
/*...e*/

/*...swrite_char:0:*/
void ProgressXWinInternal::write_char(int x, int y, char c)
	{
	if ( x < 0 || x+8 > gbm->w )
		return;
	if ( y < 0 || y+8 > gbm->h )
		return;
	if ( c < ' ' || (unsigned) c > 127 )
		c = ' ';
	switch ( xdpy->v->c_class )
		{
/*...sTrueColor\44\ DirectColor:16:*/
case TrueColor:
case DirectColor:
	{
	int xstride = gbm->w*4;
	for ( int j = 0; j < 8; j++ )
		{
		Byte *p = (Byte *) ximage->data + (y+j)*xstride + x*4;
		for ( int i = 0; i < 8; i++ )
			{
			if ( mr_font[c-' '][j][i] )
				{
				*p++ = 0xff;
				*p++ = 0xff;
				*p++ = 0xff;
				}
			else
				{
				*p++ = 0x00;
				*p++ = 0x00;
				*p++ = 0x00;
				}
			p++;
			}
		}
	}
	break;
/*...e*/
/*...sPseudoColor:16:*/
case PseudoColor:
	{
	int fg = pix[0x3f];
	int bg = pix[0x00];
	int xstride = gbm->w;
	for ( int j = 0; j < 8; j++ )
		{
		Byte *p = (Byte *) ximage->data + (y+j)*xstride + x;
		for ( int i = 0; i < 8; i++ )
			if ( mr_font[c-' '][j][i] )
				*p++ = fg;
			else
				*p++ = bg;
		}
	}
	break;
/*...e*/
		}	
	}
/*...e*/
/*...swrite_str:0:*/
void ProgressXWinInternal::write_str(int x, int y, const char *s)
	{
	for ( ; *s; s++, x+=8 )
		write_char(x, y, *s);
	}
/*...e*/
/*...sredraw:0:*/
void ProgressXWinInternal::redraw()
	{
	switch ( xdpy->v->c_class )
		{
/*...sTrueColor\44\ DirectColor:16:*/
case TrueColor:
case DirectColor:
	{
	int istride = ((gbm->w*gbm->bpp+31)/32)*4;
	int xstride = gbm->w*4;
	if ( xdpy->v->red_mask == 0xff0000 )
		for ( int y = 0; y < gbm->h; y++ )
			{
			Byte *src = data24                + y            * istride;
			Byte *dst = (Byte *) ximage->data + (gbm->h-y-1) * xstride;
			for ( int x = 0; x < gbm->w; x++ )
				{
				*dst++ = *src++;
				*dst++ = *src++;
				*dst++ = *src++;
				 dst++;
				}
			}
	else
		for ( int y = 0; y < gbm->h; y++ )
			{
			Byte *src = data24                + y            * istride;
			Byte *dst = (Byte *) ximage->data + (gbm->h-y-1) * xstride;
			for ( int x = 0; x < gbm->w; x++ )
				{
				*dst++ = src[2];
				*dst++ = src[1];
				*dst++ = src[0];
				 dst++; src += 3;
				}
			}
	}
	break;
/*...e*/
/*...sPseudoColor:16:*/
case PseudoColor:
	{
	int istride8 = ((gbm->w*8 +31)/32)*4;
	int xstride  = gbm->w;

	if ( !gbm_errdiff_4R4G4B(gbm, data24, data8) )
		fatal("out of memory");

	for ( int y = 0; y < gbm->h; y++ )
		{
		Byte *src = data8                 + y            * istride8;
		Byte *dst = (Byte *) ximage->data + (gbm->h-y-1) * xstride;
		for ( int x = 0; x < gbm->w; x++ )
			dst[x] = pix[src[x]];
		}
	}
	break;
/*...e*/
		}

	if ( show_messages )
		{
		int inx = inx_message;
		for ( int i = 0; i < N_MESSAGES; i++ )
			{
			if ( --inx < 0 )
				inx = N_MESSAGES-1;
			if ( messages[inx] == 0 )
				break;
			write_str(0, gbm->h - (i+1)*8, messages[inx]);
			}
		}

	if ( show_progress )
		{
		char s[100+1], buf[40+1];
		if ( t_started != 0 )
			{
			sprintf(s, "Start %s", str_of_time(t_started, buf));
			write_str(gbm->w-14*8, 0, s);
			}
		if ( t_fin != 0 )
			{
			sprintf(s, "Ready %s", str_of_time(t_fin, buf));
			write_str(gbm->w-14*8, 8, s);
			}
		sprintf(s, "%3d%% done", percent);
		write_str(gbm->w-9*8, 16, s);
		}
	}
/*...e*/

/*...sbegin:0:*/
void ProgressXWinInternal::begin()
	{
	t_started = time(0);
	redraw();
	expose(0, 0, gbm->w, gbm->h);
	handle_events();
	}
/*...e*/
/*...send:0:*/
void ProgressXWinInternal::end()
	{
	redraw();
	expose(0, 0, gbm->w, gbm->h);
	handle_events();
	}
/*...e*/
/*...sdone:0:*/
void ProgressXWinInternal::done(int sofar, int total)
	{
	t_fin = t_started + (((time(0) - t_started) * total) / sofar);
	int old_percent = percent;
	percent = (sofar*100)/total;
	if ( percent > old_percent )
		// Only redraw if a reasonable amount of progress made
		{
		redraw();
		expose(0, 0, gbm->w, gbm->h);
		}
	handle_events();
	}
/*...e*/
/*...smessage:0:*/
void ProgressXWinInternal::message(const char *message)
	{
	int len = strlen(message);
	if ( messages[inx_message] )
		delete[] messages[inx_message];
	messages[inx_message] = new char[len+1];
	memcpy(messages[inx_message], message, len);
	messages[inx_message][len] = '\0';
	if ( ++inx_message == N_MESSAGES )
		inx_message = 0;
	redraw();
	expose(0, 0, gbm->w, gbm->h);
	handle_events();
	}
/*...e*/
/*...e*/
/*...sclass ProgressXWin:0:*/
// Conceal internal details (needed by window class) from external users.

ProgressXWin::ProgressXWin(
	Bitmap & b,
	const char *title,
	const char *display,
	const char *geometry
	)
	{
	pwi = new ProgressXWinInternal(b, title, display, geometry);
	}
ProgressXWin::~ProgressXWin()
	{ delete pwi; }
void ProgressXWin::begin()
	{ pwi->begin(); }
void ProgressXWin::end()
	{ pwi->end(); }
void ProgressXWin::done(int sofar, int total)
	{
	pwi->done(sofar, total);
	if ( pwi->aborted )
		abort();
	}
void ProgressXWin::message(const char *message)
	{ pwi->message(message); }
/*...e*/
