//
// raytrace.h - Ray Trace a scene
//

#ifndef RAYTRACE_H
#define RAYTRACE_H

/*...sincludes:0:*/
#include "types.h"
#include "xyz.h"
#include "bitmap.h"
#include "shape.h"
#include "view.h"
#include "light.h"
#include "progress.h"

/*...vtypes\46\h:0:*/
/*...vxyz\46\h:0:*/
/*...vbitmap\46\h:0:*/
/*...vshape\46\h:0:*/
/*...vview\46\h:0:*/
/*...vlight\46\h:0:*/
/*...vprogress\46\h:0:*/
/*...e*/

// Ray firing functions

typedef	Xyz (*RAYFUNC)(
	double hfactor, double vfactor,
	double hangle, double vangle,
	const Xyz & unit_forward, const Xyz & unit_right, const Xyz & unit_up
	);

Xyz rayfunc_normal(
	double hfactor, double vfactor,
	double hangle, double vangle,
	const Xyz & unit_forward, const Xyz & unit_right, const Xyz & unit_up
	);

Xyz rayfunc_wideangle(
	double hfactor, double vfactor,
	double hangle, double vangle,
	const Xyz & unit_forward, const Xyz & unit_right, const Xyz & unit_up
	);

Xyz rayfunc_tallangle(
	double hfactor, double vfactor,
	double hangle, double vangle,
	const Xyz & unit_forward, const Xyz & unit_right, const Xyz & unit_up
	);

Xyz rayfunc_fisheye(
	double hfactor, double vfactor,
	double hangle, double vangle,
	const Xyz & unit_forward, const Xyz & unit_right, const Xyz & unit_up
	);

// Do the trace!

#define	AA_NONE		0x00		// No anti-aliasing
#define	AA_WHITTED	0x01		// Use Whitted adaptive super-sampling
#define	AA_SUPERSAMPLE	0x02		// Always super-sample by 4 each way
#define	AA_UNPIXELATE	0x03		// Unpixelate

extern double least_vis_diff;		// Used if AA_WHITTED

extern Boolean raytrace(
	Shape shape,			// Shape to trace
	const Lights & lights,		// Scene lighting
	const View & view,		// Viewpoint
	Bitmap & bitmap,		// Bitmap to render into
	Progress & progress,		// Manner to display progress
	int depth = 0,			// Recursion depth
	int aa = AA_NONE,		// Type of trace to perform
	RAYFUNC rayfunc = 0		// == rayfunc_normal
	);

#endif
