//
// rgb.h - Simple R,G,B Vector
//

#ifndef RGB_H
#define	RGB_H

/*...sincludes:0:*/
#include "types.h"

/*...vtypes\46\h:0:*/
/*...e*/

class Rgb
	{
public:
	double r, g, b;
	Rgb() {}
	Rgb(double r, double g, double b) : r(r), g(g), b(b) {}
	Rgb clamped() const;
	Rgb & operator+=(const Rgb & rgb)
		{ r += rgb.r; g += rgb.g; b += rgb.b; return *this; }
	};

inline Rgb operator+(const Rgb & p, const Rgb & q)
	{ return Rgb(p.r+q.r, p.g+q.g, p.b+q.b); }

inline Rgb operator-(const Rgb & p, const Rgb & q)
	{ return Rgb(p.r-q.r, p.g-q.g, p.b-q.b); }

inline Rgb operator*(const Rgb & p, const Rgb & q)
	{ return Rgb(p.r*q.r, p.g*q.g, p.b*q.b); }

inline Rgb operator/(const Rgb & p, const Rgb & q)
	{ return Rgb(p.r/q.r, p.g/q.g, p.b/q.b); }

inline Rgb operator*(const Rgb & p, double factor)
	{ return Rgb(p.r*factor, p.g*factor, p.b*factor); }

inline Rgb operator/(const Rgb & p, double factor)
	{ return Rgb(p.r/factor, p.g/factor, p.b/factor); }

inline Rgb operator*(double factor, const Rgb & p)
	{ return Rgb(p.r*factor, p.g*factor, p.b*factor); }

#endif
