//
// roots.h - Find roots of equations
//
// Note that these return complex roots.
//

#ifndef ROOTS_H
#define	ROOTS_H

/*...sincludes:0:*/
#ifdef NO_CINCLUDES
  #include <math.h>
  #include <complex.h>
#else
  #include <cmath>
  #include <complex>
#endif

#ifdef NO_STDNS
  #define STDNS
#else
  #define STDNS std::
#endif
/*...e*/

/*...sComplex type:0:*/
#ifdef NO_CINCLUDES
  // <math.h> or <complex.h> defines a simple complex class of two doubles
  typedef complex Complex;
#else
  // <complex> defines a templated class
  typedef STDNS complex<double> Complex;
#endif
/*...e*/

// Solve ax+b=0
//
// If a!=0.0 then there will be 1 root.
int solve_linear(double a, double b, Complex roots[]);

//         2
// Solve ax +bx+c=0
//
// If a!=0.0 then there will be 2 roots.
int solve_quadratic(double a, double b, double c, Complex roots[]);

//         3   2
// Solve ax +bx +cx+d=0
//
// If a!=0.0 then there will be 3 roots.
// First root will be real, other two may have imaginary components.
int solve_cubic(double a, double b, double c, double d, Complex roots[]);

//          4   3   2
// Solve: ax +bx +cx + dx+e=0
//
// If a!=0.0 then there will be 4 roots.
int solve_quartic(double a, double b, double c, double d, double e, Complex roots[]);

#endif
