#!/bin/ksh
#
# sm.sh - Substitution Mathematics
#
# I'm quite good at algebra, but when there are 35 coefficients, there is
# virtually no chance I'll do it all with zero errors.
# Solution is to use Maxima (see http://www.csulb.edu/~woollett/) to do the
# substitutions, and then post-process its output to collect terms the way we
# want, and then generate C++ code.
# 

# Split terms into seperate lines
# Only keep the terms
# Remove the result = prefix

clean()
	{
	sed \
		-e 's/\([-+]\)/\n\1/g' \
		-e 's/(%o[0-9][0-9]*) [a-z_][a-z_]* = /+/g' |\
	grep "^[-+]"
	}

# Expand x^2, x^3, x^4 to xx xxx xxxx

powers()
	{
	sed \
		-e 's/\([a-z_][a-z_]*\)^4/\1*\1*\1*\1/g' \
		-e 's/\([a-z_][a-z_]*\)^3/\1*\1*\1/g' \
		-e 's/\([a-z_][a-z_]*\)^2/\1*\1/g'
	}

# Merge x*y into xy
# Break into \1=sign \2=coeffs* \3=xyz* \4=COEFF and recombine
# Handle constants (ie: \3 is blank)
# Remove * from end of xyz*

coll_xyz()
	{
	sed \
		-e 's/\([xyz]\)\*\([xyz*]\)/\1\2/g' \
		-e 's/\([xyz]\)\*\([xyz*]\)/\1\2/g' \
		-e 's/\([xyz]\)\*\([xyz*]\)/\1\2/g' \
		-e 's/\([-+]\)\([^xyz]*\)\([xyz*]*\)\([^xyz]*\)/\3 \1\2\4/g' \
		-e 's/^ /c /g' \
		-e 's/^\([xyz][xyz]*\)\*/\1/g' \
		-e 's/\([XYZC][XYZC]*\)/c[QCI::\1]/g' |\
	awk ' { m[$1] = m[$1] " " $2 ; } END { for ( l in m ) printf "\tp->c[QCI::%-4s] =%s;\n", toupper(l), m[l] ; } ' |\
	sort
	}

# Merge t*t into tt etc
# Break into \1=sign \2=coeffs* \3=t* \4=COEFF and recombine
# Handle constants (ie: \3 is blank)
# Remove * from end of t*

coll_t()
	{
	sed \
		-e 's/t\*t\*t\*t/tttt/g' \
		-e 's/t\*t\*t/ttt/g' \
		-e 's/t\*t/tt/g' \
		-e 's/\([-+]\)\([^t]*\)\([t*]*\)\([^t]*\)/\3 \1\2\4/g' \
		-e 's/^ /k /g' \
		-e 's/^\(tt*\)\*/\1/g' \
		-e 's/\([XYZC][XYZC]*\)/c[QCI::\1]/g' |\
	awk ' { m[$1] = m[$1] " " $2 ; } END { for ( l in m ) printf "\tdouble %s =%s;\n", l, m[l] ; } ' |\
	sed 's/_/./g' |\
	sort |\
	sed \
		-e 's/\([-+]\)/\n		\1/g'
	}

for s in trans_x trans_y trans_z rot_x rot_y rot_z ; do
	cat sm.max | maxima | grep $s | clean | powers | coll_xyz > $s.C
done

cat sm.max | maxima | grep int | clean | powers | coll_t > int.C

exit 0
