//
// surf.C - Surface
//

/*...sincludes:0:*/
#include "surf.h"

/*...vsurf\46\h:0:*/
/*...e*/

/*...sSurf:0:*/
// Note: od and os default to black

Surf::Surf()
	:
	ka(0.8), kd(0.8), ks(0.2), kt(0.0),
	phong(100.0), rinx(1.0)
	{
	}
/*...e*/
/*...sSurf:0:*/
Surf::Surf(
	double ka, double kd, double ks, double kt,
	Col od, Col os,
	double phong, double rinx
	)
	:
	ka(ka), kd(kd), ks(ks), kt(kt),
	od(od), os(os),
	phong(phong), rinx(rinx)
	{
	}
/*...e*/
/*...sSurf \40\copy\41\:0:*/
Surf::Surf(const Surf & s)
	:
	ka(s.ka), kd(s.kd), ks(s.ks), kt(s.kt),
	od(s.od), os(s.os),
	phong(s.phong), rinx(s.rinx)
	{
	}
/*...e*/
/*...soperator\61\:0:*/
Surf & Surf::operator=(const Surf & s)
	{
	ka = s.ka; kd = s.kd; ks = s.ks; kt = s.kt;
	od = s.od; os = s.os;
	phong = s.phong; rinx = s.rinx;
	return *this;
	}
/*...e*/
/*...s\126\Surf:0:*/
Surf::~Surf() {}
/*...e*/
/*...strans\39\s:0:*/
Surf Surf::trans(Xyz t) const
	{ return Surf(ka,kd,ks,kt,od.trans  (t),os.trans  (t),phong,rinx); }
Surf Surf::trans_x(double t) const
	{ return Surf(ka,kd,ks,kt,od.trans_x(t),os.trans_x(t),phong,rinx); }
Surf Surf::trans_y(double t) const
	{ return Surf(ka,kd,ks,kt,od.trans_y(t),os.trans_y(t),phong,rinx); }
Surf Surf::trans_z(double t) const
	{ return Surf(ka,kd,ks,kt,od.trans_z(t),os.trans_z(t),phong,rinx); }
/*...e*/
/*...srot\39\s:0:*/
Surf Surf::rot_x(double angle) const
	{ return Surf(ka,kd,ks,kt,od.rot_x(angle),os.rot_x(angle),phong,rinx); }
Surf Surf::rot_y(double angle) const
	{ return Surf(ka,kd,ks,kt,od.rot_y(angle),os.rot_y(angle),phong,rinx); }
Surf Surf::rot_z(double angle) const
	{ return Surf(ka,kd,ks,kt,od.rot_z(angle),os.rot_z(angle),phong,rinx); }
/*...e*/
/*...sscale\39\s:0:*/
Surf Surf::scale(Xyz factor) const
	{ return Surf(ka,kd,ks,kt,od.scale  (factor),os.scale  (factor),phong,rinx); }

Surf Surf::scale(double factor) const
	{ return scale(Xyz(factor,factor,factor)); }

Surf Surf::scale_x(double factor) const
	{ return Surf(ka,kd,ks,kt,od.scale_x(factor),os.scale_x(factor),phong,rinx); }

Surf Surf::scale_y(double factor) const
	{ return Surf(ka,kd,ks,kt,od.scale_y(factor),os.scale_y(factor),phong,rinx); }

Surf Surf::scale_z(double factor) const
	{ return Surf(ka,kd,ks,kt,od.scale_z(factor),os.scale_z(factor),phong,rinx); }
/*...e*/
