//
// surf.h - Surface
//

/*...sdescription of surface characteristics:0:*/
// Surfaces do not emit light of their own. They only reflect and refract light
// from the light sources in the scene. The lighting/shading model used is the
// one defined in F,vD,F,H p734.
//
// Global parameters :-
//	Ia = ambient intensity (rgb vector)
//
// Parameters defined per surface :-
//	ka           = ambient-reflection-coefficient
//	kd           = diffuse coefficient, range 0.0 to 1.0
//	ks           = specular coefficient, range 0.0 to 1.0
//	kt           = transmission coefficent, range 0.0 to 1.0
//	od           = diffuse colour (rgb vector)
//	os           = specular colour (rgb vector)
//	phong_number = Phong power
//	rinx         = inside relative to outside of surface
//
// Ambient contribution is :-
//	Ia * ka * od
//
// Diffuse for light of intensity Ip, attenuated by distance by fatt, using
// Lamberts law gives :-
//	fatt * Ip * kd * od * cos_nl
//
// Specular for light of intensity Ip, attenuated by distance by fatt, using
// the Phong shading model gives :-
//	fatt * Ip * ks * os * pow(cos_rv, phong_number)
//
// Reflective component (specular only), using recursion (if depth not too deep) :-
//	intensity_from_looking_along_reflected_ray * ks * os
//
// Refractive component (transmissive), given no total internal reflection,
// using recursion (if depth not too deep) :-
//	intensity_from_refractive_ray * kt
//
// Before returning intensity, scale down by distance to origin of ray (eye).
/*...e*/

#ifndef SURF_H
#define	SURF_H

/*...sincludes:0:*/
#include "types.h"
#include "xyz.h"
#include "rgb.h"
#include "col.h"

/*...vtypes\46\h:0:*/
/*...vxyz\46\h:0:*/
/*...vrgb\46\h:0:*/
/*...vcol\46\h:0:*/
/*...e*/

class Surf
	{
public:
	double ka, kd, ks, kt;		// Ambient, diffuse, specular, trans
	Col od, os;			// Diffuse and specular colours
	double phong;			// Phong power number
	double rinx;			// Refractive index of inside

	Surf(); // Will get some naff 'default' surface
	Surf(double ka, double kd, double ks, double kt,
	     Col od, Col os, double phong, double rinx);
	Surf(const Surf & s);
	Surf & operator=(const Surf & s);
	~Surf();

	Surf trans  (Xyz t) const;
	Surf trans_x(double t) const;
	Surf trans_y(double t) const;
	Surf trans_z(double t) const;
	Surf rot_x(double angle) const;
	Surf rot_y(double angle) const;
	Surf rot_z(double angle) const;
	Surf scale  (Xyz factor) const;
	Surf scale  (double factor) const;
	Surf scale_x(double factor) const;
	Surf scale_y(double factor) const;
	Surf scale_z(double factor) const;
	};

#endif
