//
// texture.C - 3D Solid Texture Block
//

/*...sincludes:0:*/
#ifdef NO_CINCLUDES
  #include <stdio.h>
  #include <ctype.h>
  #include <stdlib.h>
  #include <stddef.h>
  #include <stdarg.h>
  #include <string.h>
  #include <iostream.h>
#else
  #include <cstdio>
  #include <cctype>
  #include <cstdlib>
  #include <cstddef>
  #include <cstdarg>
  #include <cstring>
  #include <iostream>
#endif

#ifndef NO_STDNS
  using namespace std;
#endif

extern "C" {

#if defined(AIX) || defined(LINUX) || defined(SUN) || defined(MACOSX) || defined(IPHONE)
  #include <unistd.h>
#else
  #include <io.h>
#endif
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>

#ifndef O_BINARY
  #define O_BINARY 0
#endif

}

#include "texture.h"

/*...vtexture\46\h:0:*/
/*...e*/
/*...sISO\47\POSIX:0:*/
#ifdef WIN32
/* Use ISO variants */
#define fd_open     _open
#define	fd_close    _close
#define	fd_read     _read
#define	fd_write    _write
#define	str_strcmpi _strcmpi
#else
/* Use POSIX variants */
#define fd_open     open
#define	fd_close    close
#define	fd_read     read
#define	fd_write    write
#define	str_strcmpi strcmpi
#endif
/*...e*/

/*...sPrimTexture:0:*/
PrimTexture * PrimTexture::head = 0;

/*...sPrimTextureListWithout:0:*/
PrimTexture *PrimTextureListWithout(PrimTexture *pbl, PrimTexture *pb)
	{
	if ( pbl == pb )
		return pbl->next;
	pbl->next = PrimTextureListWithout(pbl->next, pb);
	return pbl;
	}
/*...e*/

/*...stypedef dword:0:*/
#ifdef __LP64__ /* gcc symbol meaning "long and ptr are 64 bits" */
typedef unsigned int  dword;
#else
typedef unsigned long dword;
#endif
/*...e*/

#define	TEX_MAGIC ((dword) 0x1a584554)

/*...sPrimTexture \40\blank\41\:0:*/
PrimTexture::PrimTexture(int w, int h, int d, int bpv)
	:
	w(w), h(h), d(d), bpv(bpv), n(1)
	{
	stride  = ((w * bpv + 31)/32)*4;
	data = new Byte[stride * h * d];

	// Initialse surface to zeros
	memset(data, 0, stride * h * d);

	// Zero the palette too
	memset(pal, 0, sizeof(pal));

	// Keep this bitmap in the list
	fn_origin[0] = '\0';
	next = head; head = this;
	}
/*...e*/
/*...sPrimTexture \40\file\41\:0:*/
/*...sread_dword:0:*/
static dword read_dword(int fd)
	{
	Byte b[4];
	fd_read(fd, b, 4);
	return (  (dword) b [0]        +
		 ((dword) b [1] <<  8) +
		 ((dword) b [2] << 16) +
		 ((dword) b [3] << 24) );
	}
/*...e*/

PrimTexture::PrimTexture(const char *fn)
	:
	n(1)
	{
	int fd;

	strcpy(fn_origin, fn);

	if ( (fd = fd_open(fn, O_RDONLY | O_BINARY)) == -1 )
		{ cerr << "can't open " << fn << endl; exit(1); }

	if ( read_dword(fd) != TEX_MAGIC )
		{ cerr << "bad magic number in " << fn << endl; exit(1); }

	w   = (int) read_dword(fd);
	h   = (int) read_dword(fd);
	d   = (int) read_dword(fd);
	bpv = (int) read_dword(fd);

	if ( bpv != 1 && bpv != 4 && bpv != 8 && bpv != 24 )
		{ cerr << "bits per voxel is not 1,4,8 or 24, its " << bpv << endl; exit(1); }

	if ( bpv != 24 )
		if ( fd_read(fd, (char *) pal, sizeof(PAL) << bpv) != (int) ( sizeof(PAL) << bpv ) )
			{ cerr << "can't read texture file palette " << fn << endl; exit(1); }

	stride = ((w * bpv + 31)/32)*4;
	if ( (data = new Byte[stride * h * d]) == 0 )
		{ cerr << "out of memory loading texture file " << fn << endl; exit(1); }

	if ( fd_read(fd, data, (unsigned int) stride * h * d) != stride * h * d )
		{ cerr << "error reading texture file " << fn << endl; exit(1); }

	fd_close(fd);

	// Keep this bitmap in the list
	next = head; head = this;
	}
/*...e*/
/*...s\126\PrimTexture:0:*/
PrimTexture::~PrimTexture()
	{
	// Remove this bitmap from the list
	head = PrimTextureListWithout(head, this);

	delete[] data;
	}
/*...e*/
/*...swrite:0:*/
/*...swrite_dword:0:*/
static Boolean write_dword(int fd, int w)
	{
	Byte b[4];
	b[0] = (Byte)  (w & 0x000000ff);
	b[1] = (Byte) ((w & 0x0000ff00) >> 8 );
	b[2] = (Byte) ((w & 0x00ff0000) >> 16);
	b[3] = (Byte) ((w & 0xff000000) >> 24);
	return fd_write(fd, b, 4) == 4;
	}
/*...e*/

Boolean PrimTexture::write(const char *fn) const
	{
	int fd;

	if ( (fd = fd_open(fn, O_CREAT|O_TRUNC|O_WRONLY|O_BINARY,S_IREAD|S_IWRITE)) == -1 )
		return ( FALSE );

	if ( !write_dword(fd, TEX_MAGIC) ||
	     !write_dword(fd, w        ) ||
	     !write_dword(fd, h        ) ||
	     !write_dword(fd, d        ) ||
	     !write_dword(fd, bpv      ) )
		{
		fd_close(fd);
		remove(fn);
		return FALSE;
		}

	if ( bpv != 24 )
		if ( ::fd_write(fd, (char *) pal, sizeof(PAL) << bpv) != (int) ( sizeof(PAL) << bpv ) )
			{
			fd_close(fd);
			remove(fn);
			return FALSE;
			}

	if ( ::fd_write(fd, data, stride * h * d) != stride * w * d )
		{
		fd_close(fd);
		remove(fn);
		return FALSE;
		}

	fd_close(fd);

	return TRUE;
	}
/*...e*/
/*...sget_voxel:0:*/
Rgb PrimTexture::get_voxel(int x, int y, int z) const
	{
	Byte inx, r, g, b, *line = data + (z * h + y) * stride;

	switch ( bpv )
		{
		case 1:
			inx = line[x >> 3];
			inx >>= ( 7 - (x & 7) );
			inx &= 1;
			b = pal[inx].b;
			g = pal[inx].g;
			r = pal[inx].r;
			break;
		case 4:
			inx = line[x >> 1];
			if ( x & 1 )
				inx &= 0x0f;
			else
				inx >>= 4;
			b = pal[inx].b;
			g = pal[inx].g;
			r = pal[inx].r;
			break;
		case 8:
			inx = line[x];
			b = pal[inx].b;
			g = pal[inx].g;
			r = pal[inx].r;
			break;
		case 24:
			line += (x * 3);
			b = *line++;
			g = *line++;
			r = *line;
			break;
		}
	return Rgb((double) r/255.0, (double) g/255.0, (double) b/255.0);
	}
/*...e*/
/*...sset_voxel \40\rgb\41\:0:*/
// Note: We will only call this method on a 24bpp texture map, promise!

void PrimTexture::set_voxel(int x, int y, int z, const Rgb & rgb)
	{
	Byte *p = data + (z * h + y) * stride;
	p += (x * 3);
	*p++ = (Byte) (rgb.b * 255.0);
	*p++ = (Byte) (rgb.g * 255.0);
	*p   = (Byte) (rgb.r * 255.0);
	}
/*...e*/
/*...sset_voxel \40\index\41\:0:*/
// Note: We will not call this method on a 24bpp bitmap, promise!

void PrimTexture::set_voxel(int x, int y, int z, int index)
	{
	Byte *p = data + (z * h + y) * stride;

	switch ( bpv )
		{
		case 1:
			{
			p += (x >> 3);
			Byte bit = (0x80 >> (x & 7));
			if ( index )
				*p |= bit;
			else
				*p &= ~bit;
			}
			break;
		case 4:
			p += (x >> 1);
			if ( x & 1 )
				*p = ((*p & 0xf0) | index);
			else
				*p = ((*p & 0x0f) | (index << 4));
			break;
		case 8:
			p[x] = index;
			break;
		}
	}
/*...e*/
/*...sset_pal:0:*/
void PrimTexture::set_pal(int index, const Rgb & rgb)
	{
	pal[index].b = (Byte) (rgb.b * 255.0);
	pal[index].g = (Byte) (rgb.g * 255.0);
	pal[index].r = (Byte) (rgb.r * 255.0);
	}
/*...e*/
/*...e*/
/*...sTexture:0:*/
Texture::Texture(PrimTexture *p) : p(p) {}

Texture::Texture() { p = new PrimTexture(1,1,1,24); }

Texture::Texture(int w, int h, int d, int bpv) { p = new PrimTexture(w, h, d, bpv); }

Texture::Texture(const char *fn, Boolean check_cache)
	{
	if ( check_cache )
		for ( PrimTexture *pt = PrimTexture::head; pt != 0; pt = pt->next )
#ifdef UNIX
			// UNIX filenames are case sensitive
			if ( !strcmp(fn, pt->fn_origin) )
#else
			// Windows and OS/2 filenames are case insensitive
			if ( !str_strcmpi(fn, pt->fn_origin) )
#endif
				{
				p = pt;
				++(pt->n);
				return;
				}

	p = new PrimTexture(fn);
	}

Texture::Texture(const Texture & t) { p = t.p; (p->n)++; }

Texture & Texture::operator=(const Texture & t)
	{
	++(t.p->n);
	if ( --(p->n) == 0 )
		delete p;
	p = t.p;
	return *this;
	}

Texture::~Texture()
	{
	if ( --(p->n) == 0 )
		delete p;
	}
/*...e*/
