//
// types.h - Types global to all
//

#ifndef TYPES_H
#define	TYPES_H

#ifndef WIN32
// Note: MSVC 5.0/6.0 math.h includes templates in it!
// without the #ifdef __cplusplus to make it safe 
extern "C" {
#endif

#include <math.h>

#ifndef WIN32
}
#endif

#ifndef Boolean_DEFINED
#define Boolean_DEFINED
typedef int Boolean;
#define	TRUE  1
#define	FALSE 0
#endif

#ifndef Byte_DEFINED
#define	Byte_DEFINED
typedef unsigned  char  Byte;
#endif

#define	LARGEST (1.0e+20)
#ifndef PI
#define	PI 3.14159265359
#endif

inline double rad(double a) { return a/180.0*PI; }
inline double deg(double a) { return a/PI*180.0; }

#define Min(a,b) (((a)<(b))?(a):(b))
#define Max(a,b) (((a)>(b))?(a):(b))

#endif
