//
// view.C - Viewpoint in a scene
//

/*...sincludes:0:*/
#include "view.h"

/*...vview\46\h:0:*/
/*...e*/

/*...sView:0:*/
View::View()
	:
	eye    (Xyz(0.0,0.0, 5.0)),
	forward(Xyz(0.0,0.0,-1.0)),
	up     (Xyz(0.0,1.0, 0.0)),
	hangle(PI/4.0),
	vangle(PI/4.0)
	{
	}
/*...e*/
/*...sView \40\copy\41\:0:*/
View::View(const View & v)
	:
	eye    (v.eye),
	forward(v.forward),
	up     (v.up),
	hangle (v.hangle),
	vangle (v.vangle)
	{
	}
/*...e*/
/*...s\126\View:0:*/
View::~View() {}
/*...e*/
/*...strans:0:*/
void View::trans(Xyz t) { eye += t; }
/*...e*/
/*...srot_x:0:*/
void View::rot_x(double angle)
	{
	forward = forward.rot_x(angle);
	     up =      up.rot_x(angle);
	}
/*...e*/
/*...srot_y:0:*/
void View::rot_y(double angle)
	{
	forward = forward.rot_y(angle);
	     up =      up.rot_y(angle);
	}
/*...e*/
/*...srot_z:0:*/
void View::rot_z(double angle)
	{
	forward = forward.rot_z(angle);
	     up =      up.rot_z(angle);
	}
/*...e*/
/*...srot:0:*/
void View::rot(const Xyz & ad, double angle)
	{
	forward = forward.rot(ad, angle);
	     up =      up.rot(ad, angle);
	}

void View::rot(const Xyz & ao, const Xyz & ad, double angle)
	{
	forward = forward.rot(ao, ad, angle);
	     up =      up.rot(ao, ad, angle);
	}
/*...e*/
/*...sstep_\42\:0:*/
void View::step_forward(double t) { eye += t * forward; }
void View::step_backward(double t) { eye -= t * forward; }
void View::step_right(double t) { Xyz right(forward*up); eye += t * right; }
void View::step_left(double t) { Xyz right(forward*up); eye -= t * right; }
void View::step_up(double t) { eye += t * up; }
void View::step_down(double t) { eye -= t * up; }
/*...e*/
/*...sturn_\42\:0:*/
void View::turn_up(double angle)
	{
	Xyz right(forward*up);
	forward = forward.rot(right, angle);
	     up =      up.rot(right, angle);
	}
void View::turn_down(double angle)
	{
	Xyz right(forward*up);
	forward = forward.rot(right, -angle);
	     up =      up.rot(right, -angle);
	}
void View::turn_left(double angle)
	{
	forward = forward.rot(up, angle);
	}
void View::turn_right(double angle)
	{
	forward = forward.rot(up, -angle);
	}
void View::turn_clockwise(double angle)
	{
	up = up.rot(forward, angle);
	}
void View::turn_anticlockwise(double angle)
	{
	up = up.rot(forward, -angle);
	}
/*...e*/
/*...sto_view_volume:0:*/
// Return the Matrix4 which will map from world coordinates to coordinates
// in the canonical view volume defined by the 'this' view object.

Matrix4 View::to_view_volume() const
	{
	// Translate world coordinates to be relative to the viewing position
	Matrix4 vpos(1.0, 0.0, 0.0, -eye.x,
		     0.0, 1.0, 0.0, -eye.y,
		     0.0, 0.0, 1.0, -eye.z,
		     0.0, 0.0, 0.0, 1.0);

	// Build matrix with viewing frame of reference in it
	// Invert this so as to give mapping from world coords to
	// multiples of the viewing frame of reference vectors.
	// Expand from 3x3 to 4x4 matrix in this step too.
	Xyz unit_forward = forward.unit();
	Xyz unit_up      = up.unit();
	Xyz unit_right   = unit_forward * unit_up;	// Vector product
	Matrix4 vdir(Matrix3(unit_right, unit_up, unit_forward).inverse());

	// So combining vdir and vpos gives us viewpoint relative coords.
	// Coordinates will now be the multiples of unit_right,unit_up and
	// unit_forward necessary to add to eye to give world coordinate.
	// This implies we now have a left-handed coordinate system.
	Matrix4 v(vdir*vpos);

	// Now visible coordinates are those with :-
	//   z >= zmin (near clipping plane)
	//   -tan(hangle) <= x/z <= tan(hangle)
	//   -tan(vangle) <= y/z <= tan(vangle)

	// Map to canonical view volume
	Matrix4 canonical(
		1.0/tan(hangle), 0.0            , 0.0, 0.0,
		0.0            , 1.0/tan(vangle), 0.0, 0.0,
		0.0            , 0.0            , 1.0, 0.0,
		0.0            , 0.0            , 0.0, 1.0);
	return canonical*v;

	// Now visible coordinates are those with :-
	//   z >= zmin (near clipping plane)
	//   -1.0 <= x/z <= 1.0  or  -z <= x <= z
	//   -1.0 <= y/z <= 1.0  or  -z <= y <= z
	}
/*...e*/
