//
// view.h - Viewpoint in a scene
//

#ifndef VIEW_H
#define	VIEW_H

/*...sincludes:0:*/
#include "types.h"
#include "xyz.h"
#include "matrix.h"

/*...vtypes\46\h:0:*/
/*...vxyz\46\h:0:*/
/*...vmatrix\46\h:0:*/
/*...e*/

class View
	{
public:
	Xyz eye, forward, up;		// View from
	double hangle, vangle;		// Viewing angles
	View();
	View(const View & v);
	~View();
	void trans(Xyz t);
	void rot_x(double angle);
	void rot_y(double angle);
	void rot_z(double angle);
	void rot(const Xyz & ad, double angle);
		// Rotate about axis through origin, direction ad, by angle
	void rot(const Xyz & ao, const Xyz & ad, double angle);
		// Rotate about axis through ao, direction ad, by angle
	void step_forward(double t);
	void step_backward(double t);
	void step_right(double t);
	void step_left(double t);
	void step_up(double t);
	void step_down(double t);
	void turn_up(double angle);
	void turn_down(double angle);
	void turn_left(double angle);
	void turn_right(double angle);
	void turn_clockwise(double angle);
	void turn_anticlockwise(double angle);
	Matrix4 to_view_volume() const;
	};

#endif
