//
// viewer.h - Viewer for a bitmap
//

#ifndef VIEWER_H
#define	VIEWER_H

/*...sincludes:0:*/
#include "types.h"
#include "bitmap.h"

/*...vtypes\46\h:0:*/
/*...vbitmap\46\h:0:*/
/*...e*/

// All viewers respond to refresh

class Viewer
	{
public:
	Viewer() {}
	virtual ~Viewer() {}
	virtual void refresh() = 0;
	virtual int keypress() = 0;
	virtual int wait_keypress() = 0;
	};

// Specific viewer which works by writing out a new file when refresh called

class ViewerBitmapFile : public Viewer
	{
	const Bitmap & b;
	char fmt[100+1];
	int frame;
public:
	ViewerBitmapFile(
		const Bitmap & b,
		const char *fmt = "frame%03d.tif,lzw",
		int frame = 0
		);
	virtual ~ViewerBitmapFile();
	virtual void refresh();
	virtual int keypress();
	virtual int wait_keypress();
	};

#endif
