//
// viewvio.C - Viewer for a bitmap, using OS/2 Vio Fullscreen
//

/*...sincludes:0:*/
#include <string.h>
#include <process.h>
#include <iostream.h>

extern "C" {
#include "gbm.h"
}

#include "bitmap.h"
#include "viewvio.h"

/*...vbitmap\46\h:0:*/
/*...vviewvio\46\h:0:*/
/*...e*/

/*...sscn:0:*/
#define INCL_BASE
#include <os2.h>

#define	SCN_W 320
#define	SCN_H 200

static VIOMODEINFO vmiOld;
static unsigned char *ptr;

/*...sscn_lock:0:*/
static void scn_lock()
	{
	unsigned char status;
	VioScrLock(VP_WAIT, &status, (HVIO) 0);
	}
/*...e*/
/*...sscn_unlock:0:*/
static void scn_unlock()
	{
	VioScrUnLock((HVIO) 0);
	}
/*...e*/
/*...sscn_cls:0:*/
static void scn_cls()
	{
	memset(ptr, 0, SCN_W*SCN_H);
	}
/*...e*/
/*...sscn_border:0:*/
static void scn_border(Byte border)
	{
	VIOOVERSCAN vioos;

	vioos.cb = sizeof(VIOOVERSCAN);
	vioos.type = 1; /* Apparently no #define for this */
	vioos.color = border;
	VioSetState(&vioos, (HVIO) 0);
	}
/*...e*/
/*...sscn_palette\44\ scn_palette_gbm:0:*/
static void scn_palette(BYTE *palette, int first, int num)
	{
	BYTE *buf = (BYTE *) palette;
	BYTE *_Seg16 buf1616 = (BYTE *_Seg16) buf;
	VIOCOLORREG viocreg;
	viocreg.cb = sizeof(VIOCOLORREG);
	viocreg.type = 3; /* Apparently no #define for this */
	viocreg.firstcolorreg = first;
	viocreg.numcolorregs = num;

	/* Note: viocreg.colorregaddr should be of type CHAR *_Seg16
	   But it isn't! Hence if I say viocreg.colorregaddr = buf,
	   then the correct thunking will not be applied! */
	memcpy(&viocreg.colorregaddr, &buf1616, 4);

	VioSetState(&viocreg, (HVIO) 0);
	}

static void scn_palette_gbm(const GBMRGB gbmrgb[], int ncols)
	{
	BYTE palette[0x100][3];
	int i;
	for ( i = 0; i < ncols; i++ )
		{
		palette[i][0] = (gbmrgb[i].r>>2);
		palette[i][1] = (gbmrgb[i].g>>2);
		palette[i][2] = (gbmrgb[i].b>>2);
		}
	scn_palette((BYTE *) palette, 0, ncols);
	}
/*...e*/
/*...sscn_image:0:*/
static void scn_image(int x, int y, int w, int h, const unsigned char *data)
	{
	int stride = ((w+3)&~3);
	unsigned char *scn = (unsigned char *) ptr + ((y*SCN_W) + x);
	if ( x+w > SCN_W ) w = SCN_W-x;
	if ( y+h > SCN_H ) h = SCN_H-y;
	int i;
	data += (h-1) * stride;
	for ( i = 0; i < h; i++, data -= stride, scn += SCN_W )
		memcpy(scn, data, w);
	}
/*...e*/
/*...sscn_init:0:*/
static Boolean scn_init()
	{
	VIOMODEINFO vmi;
	VIOPHYSBUF phys;
	unsigned char *_Seg16 ptr1616;

	vmi.cb     = 12;
	vmi.fbType = 3;
	vmi.color  = 8;
	vmi.col    = 40;
	vmi.row    = 25;
	vmi.hres   = SCN_W;
	vmi.vres   = SCN_H;
	VioGetMode(&vmiOld, (HVIO) 0);
	if ( VioSetMode(&vmi, (HVIO) 0) )
		return FALSE;
	phys.cb = 0x10000;
	phys.pBuf = (PBYTE) 0xa0000;
	if ( VioGetPhysBuf(&phys, 0) )
		return FALSE;
	ptr1616 = (unsigned char *_Seg16) ( phys.asel[0] << 16 );
	ptr = (unsigned char *) ptr1616;

	/* Set all palette entrys to black */
	{
	static BYTE palette[0x100][3];
	memset(palette, 0, sizeof(palette));
	scn_palette((BYTE *) palette, 0, 0x100);
	}

	/* Set screen to colour 0, which will get set to black */
	scn_cls();
	return TRUE;
	}
/*...e*/
/*...sscn_term:0:*/
static void scn_term()
	{
	VioSetMode(&vmiOld, (HVIO) 0);
	}
/*...e*/
/*...sscn_keypress:0:*/
static int scn_keypress()
	{
	KBDKEYINFO kki;
	kki.chChar = '\0';
	if ( KbdCharIn(&kki, IO_NOWAIT, (HKBD) 0) == 0 &&
	     kki.chScan != '\0' && kki.chChar != '\0' )
		return kki.chChar;
	return 0;
	}
/*...e*/
/*...sscn_wait_keypress:0:*/
static int scn_wait_keypress()
	{
	KBDKEYINFO kki;
	kki.chChar = '\0';
	do
		KbdCharIn(&kki, IO_WAIT, (HKBD) 0);
	while ( kki.chScan == '\0' || kki.chChar == '\0' );
	return kki.chChar;
	}
/*...e*/
/*...e*/

ViewerVio::ViewerVio(Bitmap & b, int ncols, int border)
	{
	scn_init();
	scn_border((Byte) border);
	b.get_gbm_internals(gbm, gbmrgb, data);
	if ( gbm->w > SCN_W || gbm->h > SCN_H )
		{ cerr << "ViewerVio only supports 320x200 bitmaps or smaller" << endl; exit(1); }
	if ( gbm->bpp != 8 )
		{ cerr << "ViewerVio only supports 8bpp bitmaps" << endl; exit(1); }
	scn_palette_gbm(gbmrgb, ncols);
	}

ViewerVio::~ViewerVio()
	{
	scn_term();
	}

void ViewerVio::refresh()
	{
	scn_lock();
	scn_image(
		(SCN_W - gbm->w) / 2,
		(SCN_H - gbm->h) / 2,
		gbm->w,
		gbm->h,
		data);
	scn_unlock();
	}

int ViewerVio::keypress()
	{
	return scn_keypress();
	}

int ViewerVio::wait_keypress()
	{
	return scn_wait_keypress();
	}
