//
// viewwin.h - Viewer for a bitmap using Windows Window
//
// The Bitmap being viewed can be 1,4,8 or 24bpp.
// If you use this you'll need to link with gbmerr.lib.
// You'll also need to link with user32.lib and gdi32.lib.
//

#ifndef VIEWWIN_H
#define	VIEWWIN_H

/*...sincludes:0:*/
#include "types.h"
#include "bitmap.h"
#include "viewer.h"

/*...vtypes\46\h:0:*/
/*...vbitmap\46\h:0:*/
/*...vviewer\46\h:0:*/
/*...e*/

class ViewerWinInternal;

class ViewerWin : public Viewer
	{
	ViewerWinInternal *vwi;
public:
	enum WinFlags { centralized = 1, minimized = 2 };
	ViewerWin(
		Bitmap & b,
		int ncols = 0x100,
		const char *title = 0,
		WinFlags wf = (WinFlags) 0
		);
	virtual ~ViewerWin();
	virtual void refresh();
	virtual int keypress();
	virtual int wait_keypress();
	};

#endif
