//
// viewxwin.C - Viewer for a bitmap using an XWindows window
//

/*...sincludes:0:*/
#ifdef NO_CINCLUDES
  #include <stdio.h>
  #include <stdlib.h>
  #include <string.h>
  #include <iostream.h>
#else
  #include <cstdio>
  #include <cstdlib>
  #include <cstring>
  #include <iostream>
#endif

#ifndef NO_STDNS
  using namespace std;
#endif

extern "C" {
#include "gbm.h"
#include "gbmerr.h"
}

#include "xwin.h"
#include "bitmap.h"
#include "viewxwin.h"

/*...vxwin\46\h:0:*/
/*...vbitmap\46\h:0:*/
/*...vviewxwin\46\h:0:*/
/*...e*/

/*...sclass ViewerXWinInternal:0:*/
#define	N_KEYS 50

class ViewerXWinInternal : public XWin
	{
	XImage *ximage;
	Byte pix[0x40];

	GBM *gbm; GBMRGB *gbmrgb; Byte *data, *data24, *data8;

	char keys[N_KEYS];
	int n_keys;
	Boolean closedown;

	// Events
	virtual void expose(int x, int y, int w, int h);
	virtual void buttonrelease(int x, int y, int button);
	virtual void keypress(char c);
	virtual void close();

	void redraw();

public:
	ViewerXWinInternal(
		Bitmap & b, int ncols,
		const char *title,
		const char *display,
		const char *geometry
		);
	~ViewerXWinInternal();

	void refresh();
	int keypress();
	int wait_keypress();
	};

/*...sfatal:0:*/
static void fatal(const char *message)
	{
	cerr << message << endl;
	exit(1);
	}
/*...e*/

/*...sViewerXWinInternal:0:*/
ViewerXWinInternal::ViewerXWinInternal(
	Bitmap & b, int ncols,
	const char *title, const char *display, const char *geometry
	)
	:
	XWin(
		b.width(), b.height(),
		title != 0 ? title : "Bitmap Veiwer",
		display,
		geometry
		),
	n_keys(0),
	closedown(FALSE)
	{
	b.get_gbm_internals(gbm, gbmrgb, data);

	switch ( xdpy->v->c_class )
		{
/*...sTrueColor\44\ DirectColor:16:*/
case TrueColor:
case DirectColor:
	{
	     if ( xdpy->v->red_mask   == 0xff0000 &&
	          xdpy->v->green_mask == 0x00ff00 &&
	          xdpy->v->blue_mask  == 0x0000ff )
		;
	else if ( xdpy->v->red_mask   == 0x0000ff &&
	          xdpy->v->green_mask == 0x00ff00 &&
	          xdpy->v->blue_mask  == 0xff0000 )
		;
	else
		fatal("visual has unsupported red/green/blue masks");
	int xstride = gbm->w*4;
	ximage = XCreateImage(
		xdpy->dpy, xdpy->v,	/* display and visual */
		24,			/* image depth */
		ZPixmap,		/* XImage format */
		0,			/* offset */
		0,			/* data */
		gbm->w, gbm->h,		/* image size in pixels */
		32,			/* scanline alignment */
		0			/* let it work out bytes per line */
		);
	ximage->data = (char *) new Byte[xstride*gbm->h];
	ximage->byte_order = LSBFirst;
	}
	break;
/*...e*/
/*...sPseudoColor:16:*/
case PseudoColor:
	{
	int istride24 = ((gbm->w*24+31)/32)*4;
	int istride8  = ((gbm->w*8 +31)/32)*4;
	int xstride   = gbm->w;
	GBMRGB gbmrgb444[0x100];
	if ( gbm->bpp == 24 )
		data24 = data;
	else
		data24 = new Byte[istride24*gbm->h];
	gbm_errdiff_pal_4R4G4B(gbmrgb444);
	data8 = new Byte[istride8*gbm->h];
	for ( int i = 0; i < 0x40; i++ )
		{
		XColor col;
		col.red   = gbmrgb444[i].r * 0x0101;
		col.green = gbmrgb444[i].g * 0x0101;
		col.blue  = gbmrgb444[i].b * 0x0101;
		if ( XAllocColor(xdpy->dpy, DefaultColormap(xdpy->dpy, xdpy->scrn), &col) )
			pix[i] = col.pixel;
		else
			{
			if ( data != data24 )
				delete[] data24;
			delete[] data8;
			fatal("can't allocate 64 palette entries");
			}
		}
	ximage = XCreateImage(
		xdpy->dpy, xdpy->v,	/* display and visual */
		8,			/* image depth */
		ZPixmap,		/* XImage format */
		0,			/* offset */
		0,			/* data */
		gbm->w, gbm->h,		/* image size in pixels */
		8,			/* scanline alignment */
		0			/* let it work out bytes per line */
		);
	ximage->data = (char *) new Byte[xstride*gbm->h];
	ximage->byte_order = LSBFirst;
	}
	break;
/*...e*/
/*...sdefault:16:*/
default:
	fatal("can't work with current XWindows visual");
/*...e*/
		}

	redraw();

	XSync(xdpy->dpy, False);
	}
/*...e*/
/*...s\126\ViewerXWinInternal:0:*/
ViewerXWinInternal::~ViewerXWinInternal()
	{
	delete[] ximage->data;
	ximage->data = 0;
	XDestroyImage(ximage);

	switch ( xdpy->v->c_class )
		{
/*...sPseudoColor:16:*/
case PseudoColor:
	{
	unsigned long pixl[0x40];
	for ( int i = 0; i < 0x40; i++ )
		pixl[i] = pix[i];
	XFreeColors(xdpy->dpy, DefaultColormap(xdpy->dpy, xdpy->scrn), pixl, 0x40, 0);
	if ( data != data24 )
		delete[] data24;
	delete[] data8;
	}
	break;
/*...e*/
		}
	}
/*...e*/

/*...sexpose:0:*/
void ViewerXWinInternal::expose(int x, int y, int w, int h)
	{
	XPutImage(xdpy->dpy, w_bitmap, gc, ximage, x, y, x, y, w, h);
	}
/*...e*/
/*...sbuttonrelease:0:*/
void ViewerXWinInternal::buttonrelease(int x, int y, int button)
	{
	if ( button == 2 )
		closedown = TRUE;
	}
/*...e*/
/*...skeypress:0:*/
void ViewerXWinInternal::keypress(char c)
	{
	if ( n_keys < N_KEYS )
		keys[n_keys++] = c;
	}
/*...e*/
/*...sclose:0:*/
void ViewerXWinInternal::close()
	{
	closedown = TRUE;
	}
/*...e*/

/*...sredraw:0:*/
void ViewerXWinInternal::redraw()
	{
	switch ( xdpy->v->c_class )
		{
/*...sTrueColor\44\ DirectColor:16:*/
case TrueColor:
case DirectColor:
	{
	int istride = ((gbm->w*gbm->bpp+31)/32)*4;
	int xstride = gbm->w*4;
	if ( xdpy->v->red_mask == 0xff0000 )
		switch ( gbm->bpp )
			{
/*...s24:40:*/
case 24:
	for ( int y = 0; y < gbm->h; y++ )
		{
		Byte *src = data                  + y            * istride;
		Byte *dst = (Byte *) ximage->data + (gbm->h-y-1) * xstride;
		for ( int x = 0; x < gbm->w; x++ )
			{
			*dst++ = *src++;
			*dst++ = *src++;
			*dst++ = *src++;
			 dst++;
			}
		}
	break;
/*...e*/
/*...s8:40:*/
case 8:
	for ( int y = 0; y < gbm->h; y++ )
		{
		Byte *src = data                  + y            * istride;
		Byte *dst = (Byte *) ximage->data + (gbm->h-y-1) * xstride;
		for ( int x = 0; x < gbm->w; x++ )
			{
			Byte p = *src++;
			*dst++ = gbmrgb[p].b;
			*dst++ = gbmrgb[p].g;
			*dst++ = gbmrgb[p].r;
			 dst++;
			}
		}
	break;
/*...e*/
/*...s4:40:*/
case 4:
	for ( int y = 0; y < gbm->h; y++ )
		{
		Byte *src = data                  + y            * istride;
		Byte *dst = (Byte *) ximage->data + (gbm->h-y-1) * xstride;
		int x;
		for ( x = 0; x+2 <= gbm->w; x += 2 )
			{
			Byte p = *src++;
			*dst++ = gbmrgb[p>>4].b;
			*dst++ = gbmrgb[p>>4].g;
			*dst++ = gbmrgb[p>>4].r;
			 dst++;
			*dst++ = gbmrgb[p&15].b;
			*dst++ = gbmrgb[p&15].g;
			*dst++ = gbmrgb[p&15].r;
			 dst++;
			}
		if ( x < gbm->w )
			{
			Byte p = *src++;
			*dst++ = gbmrgb[p>>4].b;
			*dst++ = gbmrgb[p>>4].g;
			*dst++ = gbmrgb[p>>4].r;
			 dst++;
			}
		}
	break;
/*...e*/
/*...s1:40:*/
case 1:
	for ( int y = 0; y < gbm->h; y++ )
		{
		Byte *src = data                  + y            * istride;
		Byte *dst = (Byte *) ximage->data + (gbm->h-y-1) * xstride;
		Byte p;
		for ( int x = 0; x < gbm->w; x++ )
			{
			if ( (x & 7) == 0 )
				p = *src++;
			else
				p <<= 1;

			*dst++ = gbmrgb[p >> 7].b;
			*dst++ = gbmrgb[p >> 7].g;
			*dst++ = gbmrgb[p >> 7].r;
			 dst++;
			}
		}
	break;
/*...e*/
			}
	else
		switch ( gbm->bpp )
			{
/*...s24:40:*/
case 24:
	for ( int y = 0; y < gbm->h; y++ )
		{
		Byte *src = data                  + y            * istride;
		Byte *dst = (Byte *) ximage->data + (gbm->h-y-1) * xstride;
		for ( int x = 0; x < gbm->w; x++ )
			{
			*dst++ = src[2];
			*dst++ = src[1];
			*dst++ = src[0];
			 dst++; src += 3;
			}
		}
	break;
/*...e*/
/*...s8:40:*/
case 8:
	for ( int y = 0; y < gbm->h; y++ )
		{
		Byte *src = data                  + y            * istride;
		Byte *dst = (Byte *) ximage->data + (gbm->h-y-1) * xstride;
		for ( int x = 0; x < gbm->w; x++ )
			{
			Byte p = *src++;
			*dst++ = gbmrgb[p].r;
			*dst++ = gbmrgb[p].g;
			*dst++ = gbmrgb[p].b;
			 dst++;
			}
		}
	break;
/*...e*/
/*...s4:40:*/
case 4:
	for ( int y = 0; y < gbm->h; y++ )
		{
		Byte *src = data                  + y            * istride;
		Byte *dst = (Byte *) ximage->data + (gbm->h-y-1) * xstride;
		int x;
		for ( x = 0; x+2 <= gbm->w; x += 2 )
			{
			Byte p = *src++;
			*dst++ = gbmrgb[p>>4].r;
			*dst++ = gbmrgb[p>>4].g;
			*dst++ = gbmrgb[p>>4].b;
			 dst++;
			*dst++ = gbmrgb[p&15].r;
			*dst++ = gbmrgb[p&15].g;
			*dst++ = gbmrgb[p&15].b;
			 dst++;
			}
		if ( x < gbm->w )
			{
			Byte p = *src++;
			*dst++ = gbmrgb[p>>4].r;
			*dst++ = gbmrgb[p>>4].g;
			*dst++ = gbmrgb[p>>4].b;
			 dst++;
			}
		}
	break;
/*...e*/
/*...s1:40:*/
case 1:
	for ( int y = 0; y < gbm->h; y++ )
		{
		Byte *src = data                  + y            * istride;
		Byte *dst = (Byte *) ximage->data + (gbm->h-y-1) * xstride;
		Byte p;
		for ( int x = 0; x < gbm->w; x++ )
			{
			if ( (x & 7) == 0 )
				p = *src++;
			else
				p <<= 1;

			*dst++ = gbmrgb[p >> 7].r;
			*dst++ = gbmrgb[p >> 7].g;
			*dst++ = gbmrgb[p >> 7].b;
			 dst++;
			}
		}
	break;
/*...e*/
			}
	}
	break;
/*...e*/
/*...sPseudoColor:16:*/
case PseudoColor:
	{
	int istride   = ((gbm->w*gbm->bpp+31)/32)*4;
	int istride24 = ((gbm->w*24      +31)/32)*4;
	int istride8  = ((gbm->w*8       +31)/32)*4;
	int xstride   = gbm->w;

	switch ( gbm->bpp )
		{
/*...s8:32:*/
case 8:
	for ( int y = 0; y < gbm->h; y++ )
		{
		Byte *src = data   + y * istride  ;
		Byte *dst = data24 + y * istride24;
		for ( int x = 0; x < gbm->w; x++ )
			{
			Byte p = *src++;
			*dst++ = gbmrgb[p].b;
			*dst++ = gbmrgb[p].g;
			*dst++ = gbmrgb[p].r;
			}
		}
	break;
/*...e*/
/*...s4:32:*/
case 4:
	for ( int y = 0; y < gbm->h; y++ )
		{
		Byte *src = data   + y * istride  ;
		Byte *dst = data24 + y * istride24;
		int x;
		for ( x = 0; x+2 <= gbm->w; x += 2 )
			{
			Byte p = *src++;
			*dst++ = gbmrgb[p>>4].b;
			*dst++ = gbmrgb[p>>4].g;
			*dst++ = gbmrgb[p>>4].r;
			*dst++ = gbmrgb[p&15].b;
			*dst++ = gbmrgb[p&15].g;
			*dst++ = gbmrgb[p&15].r;
			}
		if ( x < gbm->w )
			{
			Byte p = *src++;
			*dst++ = gbmrgb[p>>4].b;
			*dst++ = gbmrgb[p>>4].g;
			*dst++ = gbmrgb[p>>4].r;
			}
		}
	break;
/*...e*/
/*...s1:32:*/
case 1:
	for ( int y = 0; y < gbm->h; y++ )
		{
		Byte *src = data   + y * istride  ;
		Byte *dst = data24 + y * istride24;
		Byte p;
		for ( int x = 0; x < gbm->w; x++ )
			{
			if ( (x & 7) == 0 )
				p = *src++;
			else
				p <<= 1;

			*dst++ = gbmrgb[p >> 7].b;
			*dst++ = gbmrgb[p >> 7].g;
			*dst++ = gbmrgb[p >> 7].r;
			 dst++;
			}
		}
	break;
/*...e*/
		}

	if ( !gbm_errdiff_4R4G4B(gbm, data24, data8) )
		fatal("out of memory");

	for ( int y = 0; y < gbm->h; y++ )
		{
		Byte *src = data8                 + y            * istride8;
		Byte *dst = (Byte *) ximage->data + (gbm->h-y-1) * xstride;
		for ( int x = 0; x < gbm->w; x++ )
			dst[x] = pix[src[x]];
		}
	}
	break;
/*...e*/
		}
	}
/*...e*/

/*...srefresh:0:*/
void ViewerXWinInternal::refresh()
	{
	redraw();
	expose(0, 0, gbm->w, gbm->h);
	handle_events();
	}
/*...e*/
/*...skeypress:0:*/
int ViewerXWinInternal::keypress()
	{
	handle_events();
	if ( closedown )
		return -1;
	else if ( n_keys > 0 )
		{
		int c = keys[0];
		memcpy(keys, keys+1, --n_keys);
		return c;
		}
	else
		return 0;
	}
/*...e*/
/*...swait_keypress:0:*/
int ViewerXWinInternal::wait_keypress()
	{
	for ( ;; )
		{
		int c;
		if ( (c = keypress()) != 0 )
			return c;
		// Wait 1/20th second
		struct timespec ts_req, ts_rem;
		ts_req.tv_sec = 0;
		ts_req.tv_nsec = 50000000UL;
		nanosleep(&ts_req, &ts_rem);
		}
	}
/*...e*/
/*...e*/
/*...sclass ViewerXWin:0:*/
// Conceal internal details (needed by window class) from external users.

ViewerXWin::ViewerXWin(
	Bitmap & b, int ncols,
	const char *title,
	const char *display,
	const char *geometry
	)
	{
	vwi = new ViewerXWinInternal(b, ncols, title, display, geometry);
	}
ViewerXWin::~ViewerXWin()
	{ delete vwi; }
void ViewerXWin::refresh()
	{ vwi->refresh(); }
int ViewerXWin::keypress()
	{ return vwi->keypress(); }
int ViewerXWin::wait_keypress()
	{ return vwi->wait_keypress(); }
/*...e*/
