//
// wireh.C - Wire Frame helpers
//

/*...sincludes:0:*/
#include "wireh.h"

/*...vwireh\46\h:0:*/
/*...e*/

/*...scuboid:0:*/
void cuboid(
	WireOpList & ol,
	double minx, double maxx,
	double miny, double maxy,
	double minz, double maxz
	)
	{
	ol.vertex(Xyz(maxx,maxy,maxz)) // #7
	  .vertex(Xyz(minx,maxy,maxz))
	  .vertex(Xyz(maxx,miny,maxz))
	  .vertex(Xyz(minx,miny,maxz))
	  .vertex(Xyz(maxx,maxy,minz))
	  .vertex(Xyz(minx,maxy,minz))
	  .vertex(Xyz(maxx,miny,minz))
	  .vertex(Xyz(minx,miny,minz)) // #0
	  .edge(0,1) .edge(2,3) .edge(4,5) .edge(6,7)
	  .edge(0,2) .edge(1,3) .edge(4,6) .edge(5,7)
	  .edge(0,4) .edge(1,5) .edge(2,6) .edge(3,7);
	}	
/*...e*/
/*...s\63\_ell_cyl:0:*/
void x_ell_cyl(
	WireOpList & ol,
	double ry, double rz,
	double minx, double maxx,
	int steps
	)
	{
	double da = 2.0*PI/steps;
	ol.vertex(Xyz(minx, ry, 0.0))  // #3
	  .vertex(Xyz(maxx, ry, 0.0)); // #2
	for ( double a = 0.0; a < 2.0*PI; a += da )
		ol.vertex(Xyz(minx, ry*cos(a+da), rz*sin(a+da))) // #1
		  .vertex(Xyz(maxx, ry*cos(a+da), rz*sin(a+da))) // #0
		  .edge(3,1)
		  .edge(1,0)
		  .edge(0,2);
	}

void y_ell_cyl(
	WireOpList & ol,
	double rx, double rz,
	double miny, double maxy,
	int steps
	)
	{
	double da = 2.0*PI/steps;
	ol.vertex(Xyz(0.0, miny, rz))  // #3
	  .vertex(Xyz(0.0, maxy, rz)); // #2
	for ( double a = 0.0; a < 2.0*PI; a += da )
		ol.vertex(Xyz(rx*sin(a+da), miny, rz*cos(a+da))) // #1
		  .vertex(Xyz(rx*sin(a+da), maxy, rz*cos(a+da))) // #0
		  .edge(3,1)
		  .edge(1,0)
		  .edge(0,2);
	}

void z_ell_cyl(
	WireOpList & ol,
	double rx, double ry,
	double minz, double maxz,
	int steps
	)
	{
	double da = 2.0*PI/steps;
	ol.vertex(Xyz(rx, 0.0, minz))  // #3
	  .vertex(Xyz(rx, 0.0, maxz)); // #2
	for ( double a = 0.0; a < 2.0*PI; a += da )
		ol.vertex(Xyz(rx*cos(a+da), ry*sin(a+da), minz)) // #1
		  .vertex(Xyz(rx*cos(a+da), ry*sin(a+da), maxz)) // #0
		  .edge(3,1)
		  .edge(1,0)
		  .edge(0,2);
	}
/*...e*/
