//
// wireh.h - Wire Frame helpers
//

#ifndef WIREH_H
#define	WIREH_H

/*...sincludes:0:*/
#include "types.h"
#include "xyz.h"
#include "oplist.h"
#include "wire.h"

/*...vtypes\46\h:0:*/
/*...vxyz\46\h:0:*/
/*...voplist\46\h:0:*/
/*...vwire\46\h:0:*/
/*...e*/

// Generate wire frame cubiod

void cuboid(
	WireOpList & ol,
	double minx, double maxx,
	double miny, double maxy,
	double minz, double maxz
	);

// Generation of wire frames to represent elliptical cylinders

#define	N_WIRE_STEPS 24

void x_ell_cyl(
	WireOpList & ol,
	double ry, double rz,
	double minx, double maxx,
	int steps = N_WIRE_STEPS
	);

void y_ell_cyl(
	WireOpList & ol,
	double rx, double rz,
	double miny, double maxy,
	int steps = N_WIRE_STEPS
	);

void z_ell_cyl(
	WireOpList & ol,
	double rx, double ry,
	double minz, double maxz,
	int steps = N_WIRE_STEPS
	);

#endif
