//
// xwin.C - XWindows framework
//

/*...sincludes:0:*/
#ifdef NO_CINCLUDES
  #include <stdio.h>
  #include <stdlib.h>
  #include <string.h>
  #include <iostream.h>
#else
  #include <cstdio>
  #include <cstdlib>
  #include <cstring>
  #include <iostream>
#endif

#ifndef NO_STDNS
  using namespace std;
#endif

#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>

#include "xwin.h"

/*...vxwin\46\h:0:*/
/*...e*/

/*...sfatal:0:*/
static void fatal(const char *message)
	{
	cerr << message << endl;
	exit(1);
	}
/*...e*/

/*...sXDpy:0:*/
XDpy::XDpy(const char *d)
	{
	if ( d != 0 )
		{
		display = new char[strlen(d)+1];
		strcpy(display, d);
		}
	else
		display = 0;
	if ( (dpy = XOpenDisplay(display)) == 0 )
		fatal("can't open display");
	scrn = DefaultScreen(dpy);
	v    = DefaultVisual(dpy, scrn);
	n_xwins = 1;
	}
/*...e*/
/*...s\126\XDpy:0:*/
XDpy::~XDpy()
	{
	XCloseDisplay(dpy);
	if ( display != 0 )
		delete[] display;
	}
/*...e*/

#define	MAX_XDPYS 20
static int n_xdpys = 0;
static XDpy *xdpys[MAX_XDPYS];

/*...sconnect_xdpy:0:*/
static XDpy *connect_xdpy(const char *display)
	{
	int i;
	for ( i = 0; i < n_xdpys; i++ )
		if ( xdpys[i]->display == 0 && display == 0 )
			break;
		else if ( xdpys[i]->display != 0 && display != 0 &&
			  !strcmp(xdpys[i]->display, display) )
			break;
	if ( i < n_xdpys )
		{
		++(xdpys[i]->n_xwins);
		return xdpys[i];
		}
	else if ( n_xdpys == MAX_XDPYS )
		fatal("too many displays");
	else
		{
		xdpys[n_xdpys] = new XDpy(display);
		return xdpys[n_xdpys++];
		}
	return 0; // can't get here
	}
/*...e*/
/*...sdisconnect_xdpy:0:*/
static void disconnect_xdpy(XDpy *xdpy)
	{
	int i;
	for ( i = 0; xdpys[i] != xdpy; i++ )
		;
	if ( --(xdpys[i]->n_xwins) == 0 )
		{
		delete xdpys[i];
		xdpys[i] = xdpys[--n_xdpys];
		}
	}
/*...e*/

#define	MAX_XWINS 100
static int n_xwins = 0; 
static XWin *xwins[MAX_XWINS];

/*...sXWin:0:*/
XWin::XWin(
	int width, int height,
	const char *title,
	const char *display,
	const char *geometry
	)
	{
	if ( n_xwins == MAX_XWINS )
		fatal("too many windows");
	xwins[n_xwins++] = this;

	xdpy = connect_xdpy(display);

	int winx, winy, winw, winh, flags;
	if ( geometry != 0 )
		{
		XGeometry(xdpy->dpy, xdpy->scrn, geometry, "100x100+0+0",
			0, /* border width */
			1, 1, /* font width and height */
			0, 0, /* additional interior padding */
			&winx, &winy, &winw, &winh);
		flags = USPosition|USSize; /* User specified */
		}
	else
		{
		winx = 0;
		winy = 0;
		winw = width;
		winh = height;
		flags = PSize; /* Program determined size */
		}

	{
	XSetWindowAttributes swa;
	swa.background_pixel = BlackPixel(xdpy->dpy, xdpy->scrn);
	swa.bit_gravity      = NorthWestGravity;
	swa.backing_store    = NotUseful;
	swa.event_mask       = KeyPressMask | ButtonPressMask | ButtonReleaseMask | ExposureMask;
	swa.save_under       = False;
	w = XCreateWindow(
		xdpy->dpy, RootWindow(xdpy->dpy, xdpy->scrn),
		winx, winy, winw, winh,
		0,
		DefaultDepth(xdpy->dpy, xdpy->scrn),
		InputOutput,
		xdpy->v,
		CWBackPixel|CWBitGravity|CWBackingStore|CWEventMask|CWSaveUnder,
		&swa
		);
	}

	XStoreName(xdpy->dpy, w, title);
	XSetIconName(xdpy->dpy, w, title);

	{
	XSizeHints sh;
	sh.width      = winw;
	sh.height     = winh;
	sh.min_width  = sh.max_width  = width;
	sh.min_height = sh.max_height = height;
	sh.x          = winx;
	sh.y          = winy;
	sh.flags      = PMinSize | PMaxSize | flags;
	XSetNormalHints(xdpy->dpy, w, &sh);
	}

	{
	XClassHint ch;
	ch.res_class = (char *) "Xprogxwin";
	ch.res_name  = (char *) "xprogxwin";
	XSetClassHint(xdpy->dpy, w, &ch);
	}

	{
	Atom proto_atom;
	proto_atom  = XInternAtom(xdpy->dpy, (char *) "WM_PROTOCOLS"    , False);
	delete_atom = XInternAtom(xdpy->dpy, (char *) "WM_DELETE_WINDOW", False);
	if ( proto_atom != None && delete_atom != None )
		XChangeProperty(xdpy->dpy, w, proto_atom, XA_ATOM, 32,
			PropModeReplace, (unsigned char *) &delete_atom, 1);
	}

	{
	XSetWindowAttributes swa;
	swa.background_pixel = BlackPixel(xdpy->dpy, xdpy->scrn);
	swa.bit_gravity      = NorthWestGravity;
	swa.backing_store    = WhenMapped;
	swa.event_mask       = ExposureMask;
	swa.save_under       = False;
	w_bitmap = XCreateWindow(
		xdpy->dpy, w,
		0, 0, width, height,
		0,
		DefaultDepth(xdpy->dpy, xdpy->scrn),
		InputOutput,
		xdpy->v,
		CWBackPixel|CWBitGravity|CWBackingStore|CWEventMask|CWSaveUnder,
		&swa
		);
	}

	{
	XSizeHints sh;
	sh.width      = width;
	sh.height     = height;
	sh.min_width  = sh.max_width  = width;
	sh.min_height = sh.max_height = height;
	sh.flags      = PMinSize | PMaxSize | PSize;
	XSetNormalHints(xdpy->dpy, w_bitmap, &sh);
	}

	{
	XClassHint ch;
	ch.res_class = (char *) "Xmrxwin";
	ch.res_name  = (char *) "xmrxwin";
	XSetClassHint(xdpy->dpy, w_bitmap, &ch);
	}

	{
	XGCValues gcv;
	gcv.function = GXcopy;
	gc = XCreateGC(xdpy->dpy, w_bitmap, GCFunction, &gcv);
	}

	XMapWindow(xdpy->dpy, w_bitmap);
	XMapWindow(xdpy->dpy, w);

	XSync(xdpy->dpy, False);
	}
/*...e*/
/*...s\126\XWin:0:*/
XWin::~XWin()
	{
	XFreeGC(xdpy->dpy, gc);

	XDestroyWindow(xdpy->dpy, w_bitmap);
	XDestroyWindow(xdpy->dpy, w);

	disconnect_xdpy(xdpy);

	int i;
	for ( i = 0; xwins[i] != this; i++ )
		;
	xwins[i] = xwins[--n_xwins];
	}
/*...e*/

void XWin::expose(int x, int y, int w, int h) {}
void XWin::buttonpress(int x, int y, int button) {}
void XWin::buttonrelease(int x, int y, int button) {}
void XWin::keypress(char c) {}
void XWin::close() {}

/*...sfind_xwin_w:0:*/
static XWin *find_xwin_w(Window w)
	{
	for ( int i = 0; i < n_xwins; i++ )
		if ( xwins[i]->w == w )
			return xwins[i];
	return 0;
	}
/*...e*/
/*...sfind_xwin_w_bitmap:0:*/
static XWin *find_xwin_w_bitmap(Window w)
	{
	for ( int i = 0; i < n_xwins; i++ )
		if ( xwins[i]->w_bitmap == w )
			return xwins[i];
	return 0;
	}
/*...e*/

/*...shandle_events:0:*/
void handle_events()
	{
	for ( int i = 0; i < n_xdpys; i++ )
		{
		XDpy *xdpy = xdpys[i];
		while ( XPending(xdpy->dpy) )
			{
			XEvent event;
			XNextEvent(xdpy->dpy, &event);
			XWin *xwin;
			switch ( event.type )
				{
/*...sExpose:32:*/
case Expose:
	if ( (xwin = find_xwin_w_bitmap(event.xexpose.window)) != 0 )
		xwin->expose(
			event.xexpose.x,
			event.xexpose.y,
			event.xexpose.width,
			event.xexpose.height
			);
	break;
/*...e*/
/*...sButtonPress:32:*/
case ButtonPress:
	if ( (xwin = find_xwin_w(event.xbutton.window)) != 0 )
		xwin->buttonpress(
			event.xbutton.x,
			event.xbutton.y,
			event.xbutton.button
			);
	break;
/*...e*/
/*...sButtonRelease:32:*/
case ButtonRelease:
	if ( (xwin = find_xwin_w(event.xbutton.window)) != 0 )
		xwin->buttonrelease(
			event.xbutton.x,
			event.xbutton.y,
			event.xbutton.button
			);
	break;
/*...e*/
/*...sKeyPress:32:*/
case KeyPress:
	if ( (xwin = find_xwin_w(event.xkey.window)) != 0 )
		{
		char buf[128];
		KeySym ks;
		XComposeStatus cs;
		if ( XLookupString(&(event.xkey), buf, 128, &ks, &cs) == 1 )
			xwin->keypress(buf[0]);
		}
	break;
/*...e*/
/*...sClientMessage:32:*/
case ClientMessage:
	if ( (xwin = find_xwin_w(event.xclient.window)) != 0 )
		if ( event.xclient.data.l[0] == xwin->delete_atom )
			xwin->close();
	break;
/*...e*/
				}
			}
		}
	}	
/*...e*/
