//
// xwin.h - XWindows framework
//
// We may wish to display a number of XWindows windows.
// Each may be on a different display, or not.
// So windows share connections to displays.
//
// Derivations of XWin are expected to override the Event handling
// methods to respond to input and to repaint themselves. 
//
// Derivations of XWin are expected to determine the visual and build backing
// unpalettised or palettised XImages and allocate palette entries as required.
//

#ifndef XWIN_H
#define XWIN_H

/*...sincludes:0:*/
#ifdef NO_CINCLUDES
  #include <stdio.h>
  #include <stdlib.h>
  #include <string.h>
#else
  #include <cstdio>
  #include <cstdlib>
  #include <cstring>
#endif

#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
/*...e*/

class XDpy
	{
public:
	char *display;
	Display *dpy;
	int scrn;
	Visual *v;
	int n_xwins;
	XDpy(const char *d);
	~XDpy();
	};

class XWin
	{
protected:
	XDpy *xdpy;
	GC gc;
public:
	Window w, w_bitmap;
	Atom delete_atom;
	// Events
	virtual void expose(int x, int y, int w, int h);
	virtual void buttonpress(int x, int y, int button);
	virtual void buttonrelease(int x, int y, int button);
	virtual void keypress(char c);
	virtual void close();
	XWin(
		int width, int height,
		const char *title,
		const char *display = 0,
		const char *geometry = 0
		);
	~XWin();
	};

// Handle any pending XWindows events for any of our windows
extern void handle_events();

#endif
