//
// xyz.C - Simple X,Y,Z Vector
//

/*...sincludes:0:*/
#include "xyz.h"

/*...vxyz\46\h:0:*/
/*...e*/

/*...srot_x \45\ rotate about x axis\44\ y\45\\62\z:0:*/
Xyz Xyz::rot_x(double angle) const
	{
	double ca = cos(angle), sa = sin(angle);
	return Xyz(x, ca*y-sa*z, sa*y+ca*z);
	}
/*...e*/
/*...srot_y \45\ rotate about y axis\44\ z\45\\62\x:0:*/
Xyz Xyz::rot_y(double angle) const
	{
	double ca = cos(angle), sa = sin(angle);
	return Xyz(sa*z + ca*x, y, ca*z-sa*x);
	}
/*...e*/
/*...srot_z \45\ rotate about z axis\44\ x\45\\62\y:0:*/
Xyz Xyz::rot_z(double angle) const
	{
	double ca = cos(angle), sa = sin(angle);
	return Xyz(ca*x-sa*y, sa*x+ca*y, z);
	}
/*...e*/
/*...srot   \45\ rotate about arbitrary axis through origin:0:*/
// Determine what it takes to move the axis into the x-z plane
// Determine what it takes to move it onto the x axis
// Rotate about X axis

Xyz Xyz::rot(const Xyz & ad, double angle) const
	{
	double angle_z = atan2(ad.y, ad.x);
	Xyz ad2(ad.rot_z(-angle_z));
	double angle_y = atan2(ad2.z, ad2.x);
	return rot_z(-angle_z).rot_y(angle_y)
	      .rot_x(angle)
	      .rot_y(-angle_y).rot_z(angle_z);
	}
/*...e*/
/*...srot   \45\ rotate about arbitrary axis:0:*/
// Translate to origin, do rotation, translate back

Xyz Xyz::rot(const Xyz & ao, const Xyz & ad, double angle) const
	{
	return ( Xyz(x,y,z) - ao ).rot(ad, angle) + ao;
	}	
/*...e*/
