//
// xyz.h - Simple X,Y,Z Vector
//

#ifndef XYZ_H
#define	XYZ_H

/*...sincludes:0:*/
#include "types.h"

/*...vtypes\46\h:0:*/
/*...e*/

class Xyz
	{
public:
	double x, y, z;
	Xyz() {}
	Xyz(double x, double y, double z) : x(x), y(y), z(z) {}
	double magnitude2() const { return      x*x+y*y+z*z ; }
	double magnitude () const { return sqrt(x*x+y*y+z*z); }
	Xyz unit() const
		{ double mag = magnitude(); return Xyz(x/mag, y/mag, z/mag); }
	Xyz rot_x(double angle) const;
		// Rotate about x axis, y->z
	Xyz rot_y(double angle) const;
		// Rotate about y axis, z->x
	Xyz rot_z(double angle) const;
		// Rotate about z axis, x->y
	Xyz rot(const Xyz & ad, double angle) const;
		// Rotate about axis through origin, direction ad, by angle
	Xyz rot(const Xyz & ao, const Xyz & ad, double angle) const;
		// Rotate about axis through ao, direction ad, by angle
	Xyz & operator+=(const Xyz & xyz)
		{ x += xyz.x; y += xyz.y; z += xyz.z; return *this; }
	Xyz & operator-=(const Xyz & xyz)
		{ x -= xyz.x; y -= xyz.y; z -= xyz.z; return *this; }
	Xyz & operator*=(double factor)
		{ x *= factor; y *= factor; z *= factor; return *this; }
	};

inline int operator==(const Xyz & p, const Xyz & q)
	{ return p.x==q.x && p.y==q.y && p.z==q.z; }

inline int operator!=(const Xyz & p, const Xyz & q)
	{ return p.x!=q.x || p.y!=q.y || p.z!=q.z; }

inline Xyz operator+(const Xyz & p, const Xyz & q)
	{ return Xyz(p.x+q.x, p.y+q.y, p.z+q.z); }

inline Xyz operator-(const Xyz & p, const Xyz & q)
	{ return Xyz(p.x-q.x, p.y-q.y, p.z-q.z); }

inline Xyz operator-(const Xyz & p)
	{ return Xyz(-p.x,-p.y,-p.z); }

inline Xyz operator*(const Xyz & p, const Xyz & q)
	{ return Xyz(p.y*q.z-p.z*q.y, p.z*q.x-p.x*q.z, p.x*q.y-p.y*q.x); }

inline double scalar_product(const Xyz & p, const Xyz & q)
	{ return p.x*q.x + p.y*q.y + p.z*q.z; }

inline Xyz scale_by(const Xyz & p, const Xyz & q)
	{ return Xyz(p.x*q.x, p.y*q.y, p.z*q.z); }

inline Xyz operator*(const Xyz & p, double factor)
	{ return Xyz(p.x*factor, p.y*factor, p.z*factor); }

inline Xyz operator/(const Xyz & p, double factor)
	{ return Xyz(p.x/factor, p.y/factor, p.z/factor); }

inline Xyz operator*(double factor, const Xyz & p)
	{ return Xyz(p.x*factor, p.y*factor, p.z*factor); }

#endif
