/*

nara.c - Nara mono dithered video demo

*/

/*...sincludes:0:*/
#include "video.h"
#include "sound.h"
#include "dsk.h"

/*...vvideo\46\h:0:*/
/*...vsound\46\h:0:*/
/*...vdsk\46\h:0:*/
/*...e*/

#define	PATGEN	0
#define	PATCOL	(8*1024)
#define	PATNAM	(6*1024)
#define	SPRATT	(16*1024-128)
#define	SPRGEN	(14*1024)

static unsigned char buf[2048];

int main(void)
	{
	int i, x, y;

	voutrg(0x00, 0x02); // grf mode II
	voutrg(0x01, 0xc2); // display enabled, interrupts not
	voutrg(0x02, PATNAM/0x0400);
	voutrg(0x03, PATCOL/0x0040+127);
	voutrg(0x04, PATGEN/0x0800+3);
	voutrg(0x05, SPRATT/0x0080);
	voutrg(0x06, SPRGEN/0x0800);
	voutrg(0x07, 0x06);

	sndvol(0, 15);
	sndvol(1, 15);
	sndvol(2, 15);
	sndvol(3, 15);

	vsetot(PATGEN);
	for ( i = 0; i < 6*1024; i++ )
		vdoutp(0x00);
	vsetot(PATCOL);
	for ( i = 0; i < 6*1024; i++ )
		vdoutp(0x18);
	vsetot(PATNAM);
	for ( i = 0; i < 24*32; i++ )
		vdoutp((unsigned char) i);

	for ( y = 4; y < 20; y++ )
		{
		vsetot(PATCOL+(y*32+6)*8);
		for ( x = 0; x < 20*8; x++ )
			vdoutp(0xf1);
		}

	vsetot(SPRATT);
	vdoutp(0xd0); // terminate sprite list

	for ( i = 0; i < sizeof(buf); i++ )
		buf[i] = (unsigned char) i;

	if ( ! dsk_init() )
		{
		voutrg(0x07,0x06);
		for ( ;; )
			;
		}

	for ( ;; )
		{
		unsigned frame;
		unsigned long block = 0;
		for ( frame = 0; frame < 500; frame++ )
			{
			dsk_read(block, 5, buf);
			block += 5;
			vsync();
			vblockvideo(buf);
			}
		}
	}
