;
; sidisc.s - MTX Silicon Disc routines
;
        .module sidisc

p_sid0	=	0x50

        .area   _CODE

; int sidcheck(unsigned drive)
_sidcheck::
	pop	hl
	pop	bc
	push	bc
	push	hl
	ld	a,c
	add	a,a
	add	a,a
	add	a,#p_sid0+3
	ld	c,a
	call	sidcheck2
	in	b,(c)		; original value
	call	sidcheck2
	ld	a,b
	cpl
	out	(c),a
	call	sidcheck2
	in	a,(c)
	cpl
	cp	b
	jr	nz,sidcheck1
	call	sidcheck2
	out	(c),b
	ld	hl,#1
	ret
sidcheck1:
	ld	hl,#0
	ret
; reset to start of platter, ready to access first byte on it
sidcheck2:
	dec	c
	dec	c
	dec	c
	xor	a
	out	(c),a
	inc	c
	out	(c),a
	inc	c
	inc	c
	ret

; int sidread(unsigned drive, unsigned long sector, unsigned count, unsigned char *dest)
_sidread::
	ld	iy,#0
	add	iy,sp
	ld	a,2(iy)
	add	a,a
	add	a,a
	add	a,#p_sid0
	ld	c,a
	ld	b,8(iy)
	ld	l,10(iy)
	ld	h,11(iy)
siread2:
	push	bc
	ld	a,4(iy)
	out	(c),a
	inc	c
	ld	a,5(iy)
	out	(c),a
	inc	c
	ld	a,6(iy)
	out	(c),a
	inc	c
	ld	b,#128
siread4:
	ini				; 16T
	jr	nz,siread4		; 12T
	call	incblock
	pop	bc
	djnz	siread2
	ret

; int sidwrite(unsigned drive, unsigned long sector, unsigned count, const unsigned char *dest)
_siwrite::
	ld	iy,#0
	add	iy,sp
	ld	a,2(iy)
	add	a,a
	add	a,a
	add	a,#p_sid0
	ld	c,a
	ld	b,8(iy)
	ld	l,10(iy)
	ld	h,11(iy)
siwrite2:
	push	bc
	ld	a,4(iy)
	out	(c),a
	inc	c
	ld	a,5(iy)
	out	(c),a
	inc	c
	ld	a,6(iy)
	out	(c),a
	inc	c
	ld	b,#128
siwrite4:
	outi				; 16T
	jr	nz,siwrite4		; 12T
	call	incblock
	pop	bc
	djnz	siwrite2
	ret

;
incblock:
	inc	4(iy)
	ret	nz
	inc	5(iy)
	ret	nz
	inc	6(iy)
	ret
