;
; sound.s - MTX sound routines
;
        .module sound

p_sndo	=	0x06
p_sndi	=	0x03

        .area   _CODE

; void sndvol(unsigned char channel, unsigned char volume)
_sndvol::
	pop	hl
	pop	de
	ld	a,e
	add	a,a
	inc	a
	add	a,a
	add	a,a
	add	a,a
	add	a,a
	or	#0x80
	or	d
	out	(p_sndo),a
	in	a,(p_sndi)
	push	de
	jp	(hl)

; void sndfre(unsigned char channel, unsigned freq)
_sndfre::
	pop	hl
	pop	de
	dec	sp
	pop	bc
	ld	a,e
	add	a,a
	add	a,a
	add	a,a
	add	a,a
	add	a,a
	or	#0x80
	ld	d,a
	ld	a,c
	and	#0x0f
	or	d
	out	(p_sndo),a
	in	a,(p_sndi)
	sla	c
	rl	b
	sla	c
	rl	b
	sla	c
	rl	b
	sla	c
	rl	b
	ld	a,b
	out	(p_sndo),a
	in	a,(p_sndi)
	dec	sp
	dec	sp
	dec	sp
	jp	(hl)	

; void noityp(unsigned char type)
_noityp::
	pop	hl
	pop	de
	push	de
	sla	e
	sla	e
	ld	a,#0xe1
	or	e
	out	(p_sndo),a
	in	a,(p_sndi)
	jp	(hl)
