/*

video.h - MTX video routines

reg in 0..7
addr in 0..16383

*/

#ifndef VIDEO_H
#define	VIDEO_H

extern void voutrg(unsigned char reg, unsigned char value);
extern unsigned char vinreg(void);
extern void vsetot(unsigned addr);
extern void vdoutp(unsigned char value);
extern void vsetrd(unsigned addr);
extern unsigned char vdinpt(void);
extern void vsync(void);

/* blocksize is a (ideally large) multiple of 8, with 0 meaning 256 */
extern void vblock(const unsigned char *src, unsigned char blocksize, unsigned char blocks);

/* special case for video copy */
extern void vblockvideo(const unsigned char *src);

#endif
