;
; video.s - MTX video routines
;
        .module video

p_vdpd	=	0x01
p_vdpc	=	0x02

        .area   _CODE

; void voutrg(unsigned char reg, unsigned char value)
_voutrg::
	pop	hl
	pop	de
	ld	a,d
	out	(p_vdpc),a
	ld	a,e
	or	#0x80
	out	(p_vdpc),a
	push	de
	jp	(hl)

; unsigned char vinreg(void)
_vinreg::
	in	a,(p_vdpc)
	ld	l,a
	ret

; void vsetot(unsigned addr)
_vsetot::
	pop	hl
	pop	de
	ld	a,e
	out	(p_vdpc),a
	ld	a,d
	or	#0x40
	out	(p_vdpc),a
	push	de
	jp	(hl)

; void vdoutp(unsigned char value)
_vdoutp::
	pop	hl
	pop	de
	ld	a,e
	out	(p_vdpd),a	; 11T
	push	de		; 11T
	inc	de		;  6T pad
	jp	(hl)		;  4T

; void vsetrd(unsigned addr)
_vsetrd::
	pop	hl
	pop	de
	ld	a,e
	out	(p_vdpc),a
	ld	a,d
	out	(p_vdpc),a
	push	de
	jp	(hl)

; unsigned char vdinpt(void)
_vdinpt::
	in	a,(p_vdpd)	; 11T
	ld	l,a		;  4T
	or	a,#0x00		;  7T pad
	ret			; 10T

; void vsync(void)
_vsync::
	in	a,(p_vdpc)
	and	#0x80
	jr	nz,_vsync
vsync2:
	in	a,(p_vdpc)
	and	#0x80
	jr	z,vsync2
	ret

; void vblock(const unsigned char *src, unsigned char blocksize, unsigned char blocks)
_vblock::
	pop	hl
	pop	hl
	pop	de
	ld	c,#p_vdpd
vblock1:
	ld	b,e
vblock2:
	outi			; 16T
	outi			; 16T
	outi			; 16T
	outi			; 16T
	outi			; 16T
	outi			; 16T
	outi			; 16T
	outi			; 16T
	jp	nz,vblock2
	dec	d
	jr	nz,vblock1
	ld	hl,#-6		;  6T
	add	hl,sp		; 11T
	ld	sp,hl		;  6T
	ret

; special routine for video experiment
; 20x16 character area 2 lines 6 characters in
; void vblockvideo(const unsigned char *src)
_vblockvideo::
	pop	hl
	pop	hl
	ld	c,#p_vdpd
	ld	de,#0x44*256+11
				; d=y+0x40, e=count
vblockvideo1:
	ld	a,#6*8
	out	(p_vdpc),a
	ld	a,d
	out	(p_vdpc),a
	ld	b,#20*8
vblockvideo2:
	outi			; 16T
	outi			; 16T
	outi			; 16T
	outi			; 16T
	outi			; 16T
	outi			; 16T
	outi			; 16T
	outi			; 16T
	outi			; 16T
	outi			; 16T
	outi			; 16T
	outi			; 16T
	outi			; 16T
	outi			; 16T
	outi			; 16T
	outi			; 16T
	jp	nz,vblockvideo2	; 10T
	inc	d
	dec	e
	jr	nz,vblockvideo1
; now the last lines slowly
	ld	e,#5
vblockvideo3:
	ld	a,#6*8
	out	(p_vdpc),a
	ld	a,d
	out	(p_vdpc),a
	ld	b,#20*8
vblockvideo4:
	outi			; 16T
	nop			;  4T pad
	jr	nz,vblockvideo4	; 12T/7T pad
	inc	d
	dec	e
	jr	nz,vblockvideo3
;
	ld	hl,#-4
	add	hl,sp
	ld	sp,hl
	ret
